import instance from './ajax'

/**
 * 获取模块视图列表
 */
export const getModuleViewList = (params, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/" + params.moduleId + "/views?searchword=" + params.searchword + "&pageNo=" + params.pageNo + "&linesPerPage=" + params.linesPerPage)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 根据视图创建菜单
 */
export const createViewMenu = (params, data, { onSucess, onError }) => {
  instance({
    url: contextPath + `/designtime/applications/${params.appId}/view/${params.id}/menus`,
    method: "POST",
    data: data,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 复制视图
 */
export const copyView = (multipleSelectionId, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/modules/views/copy",
    method: "POST",
    data: multipleSelectionId,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 删除视图
 */ 
export const deleteModuleView = (multipleSelectionId) => {
return instance({
    url: contextPath + "/designtime/applications/modules/views",
    method: "DELETE",
    data: multipleSelectionId,
  })
};

/**
 *
 * 获取视图数据
 */
export const getModuleViewData = (viewId, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/views/" + viewId)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};
/**
 * 新建保存视图
 */
export const saveAddModuleView = (params, data) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/modules/" + params.moduleId + "/views?viewType=" + params.viewType,
    method: "post",
    data,
  })
};

/**
 * 更新保存视图
 */
export const saveEditModuleView = (params, data) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/modules/" + params.moduleId + "/views/" + params.viewId + "?viewType=" + params.viewType,
    method: "put",
    data,
  })
};

/**
 *
 * 获取系统筛选字段**
 */
export const getSystemScreeningFields = (fromId) => {
  return instance({
    url: contextPath + "/designtime/applications/getSystemScreeningFields/" + fromId,
    method: "get"
  })
};

/**
 *
 * 获取筛选字段获取作用域**
 */
export const getScopeByField = (authField) => {
  return instance({
    url: contextPath + "/designtime/applications/getScopeByField/" + authField,
    method: "get"
  })
};

/**
 *
 * 获取筛选字段获取作用域**
 */
export const getFormValueStoreFields = (formId, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/getFormValueStoreFields/" + formId)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 *
 * 获取视图列列表****
 */
export const getViewColumns = (viewId) => {
  return instance({
    url: contextPath + "/designtime/applications/modules/views/" + viewId + "/columns",
    method: "get"
  })
};
/**
 * 新建保存视图列
 */
export const saveColumnsView = (params, data, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/" + params.applicationId + "/modules/views/" + params.viewId + "/columns",
    method: "POST",
    data: data,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};
/**
 * 批量新建视图列
 */
export const saveBatchColumnsView = (params, data, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/modules/views/" + params.viewId + "/columns/batch",
    method: "POST",
    data: data,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};
/**
 * 更新保存视图列
 */
export const updateColumnsView = (params, columnId, data, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/modules/views/" + params.viewId + "/columns/" + columnId,
    method: "PUT",
    data: data,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};
/**
 * 删除视图列
 */
export const deleteColumnsView = (ids) => {
  return instance({
    url: contextPath + "/designtime/applications/modules/views/columns",
    method: "delete",
    data: ids,
  })
};
/**
 *
 * 获取视图列列表详情******
 */
export const getViewColumnsData = (columnId, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/views/columns/" + columnId)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 *
 * 视图列排序修改******
 */
export const updateColumnOrder = (oId, nId, { onSucess, onError }) => {
  instance({
    url: contextPath + `/designtime/applications/views/column/order?oId=${oId}&nId=${nId}`,
    method: "PUT",
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
}

/**
 *
 * 获取视图操作列表******
 */
export const getViewActivitys = (viewId, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/views/" + viewId + "/activitys")
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 新建保存视图操作
 */
export const saveActivitysView = (params, data, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/modules/views/" + params.viewId + "/activitys",
    method: "POST",
    data: data,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 更新视图操作
 */
export const updateActivitysView = (params, data, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/modules/views/" + params.viewId + "/activitys/" + params.activityId,
    method: "PUT",
    data: data,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 新建视图操作动作为导入Excel时的导入映射
 */
export const reqImportMap = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/excelconfigs?name=" + params.name + "&pageNo=" + params.pageNo + "&linesPerPage=" + params.linesPerPage,
    method: 'get'
  })
};

/**
 * 删除视图操作
 */
export const delActivitysView = (ids) => {
  return instance({
    url: contextPath + "/designtime/applications/modules/views/activitys",
    method: "delete",
    data: ids,
  })
};

/**
 * 修改操作页面排序
 */
export const updateActivityOrder = (oId, nId, { onSucess, onError }) => {
  instance({
    url: contextPath + `/designtime/applications/activity/order?oId=${oId}&nId=${nId}`,
    method: "PUT",
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
}


/**
 * 获取链接列表
 */
export const reqLinkList = (params, { onSucess, onError }) => {
  instance
    .get(contextPath + `/designtime/applications/${params.appId}/links?name=${params.name}&pageNo=${params.pageNo}&linesPerPage=${params.linesPerPage}&type=${params.type}`)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 获取链接详情
 */
export const reqLinkDetail = (linkId, { onSucess, onError }) => {
  instance
    .get(contextPath + `/designtime/applications/links/${linkId}`)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 新建链接
 */
export const addLinkDetail = (appId, data, { onSucess, onError }) => {
  instance({
    url: contextPath + `/designtime/applications/${appId}/links`,
    method: "POST",
    data: data,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 更新链接
 */
export const updateLinkDetail = (data, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/links",
    method: "PUT",
    data: data,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 删除链接（可批量）
 */
export const delLinkList = (ids) => {
  return instance({
    url: contextPath + "/designtime/applications/links",
    method: "delete",
    data: ids,
  })
};