import AbstractElement from "../AbstractElement";
import { Sequence } from "../../utility";

class AbstractField extends AbstractElement{
    constructor() {
        super();
        this.style={
            padding:"5px 10px 10px",
            display:"inline-block",
            "min-height":"30px",
            width:"100%",
            "border-left": "5px solid transparent",
            "border-color": "#fff",
            "background-color": "#fff",
            "position":'relative',
            "vertical-align": 'top'
        };
        this.html="";
        this.propValues.layout="horizontal";//布局

        
    }
    creat(){
        this.htmlDOM = document.createElement("div");
        this.style["border-color"]="#0DB3A6";   
        this.style["background-color"]="#EBF8FB";

        Object.assign(this.htmlDOM.style,this.style);
        this.isChecked=true;
        this.htmlDOM.setAttribute("name",this.propValues.name);
        this.htmlDOM.setAttribute("id",this.propValues.id);
        this.htmlDOM.setAttribute("draggable",true);
        this._bindEvent(this.htmlDOM);
        this.html+=`<div class="delete"><i class="btn-delete" title="删除"></i></div>`
        this.htmlDOM.innerHTML=this.html;
        if(this.container.setElem!=null)
        this.container.htmlDOM.insertBefore(this.htmlDOM,this.container.setElem.htmlDOM);
        else
        this.container.htmlDOM.appendChild(this.htmlDOM);
        this.setnameIndex();
    }
    _bindEvent(div){
        let that=this;
        div.onclick = (e)=>{ 
            e.stopPropagation();
            let target = e.target||e.srcElement;
            while(target.tagName!='TAB-CONTENT' && target.tagName!='BODY'){
                target=target.parentNode;
            }
            if(target.tagName=='TAB-CONTENT'){
                // 先注释，获取的索引值不正确，应该是tab页签选中第几个，index就是当前的页签
                // let index = Array.prototype.indexOf.call(e.target.parentNode.children,e.target);
                // 找出选中的是第几个标签页[只符合只有一层标签页不符合有嵌套的]

                
                // yx 隐藏表单中select的下拉框
                let selects = target.querySelectorAll('select')
                for(let s = 0; s < selects.length; s++){
                    selects[s].blur()
                }
    
                let index = null
                for(let k = 0; k < this.htmlDOM.children[0].children[0].children.length; k++){ //this.htmlDOM.children[0].children[0].children: 第几个选项卡被选中
                    if(this.htmlDOM.children[0].children[0].children[k].className == 'normalTabCheck'){
                        index = k
                    }
                }
                // 获取所有的formId进行初始化
                let formIdArr = []
                that.propValues.relstr.map(item => {
                    formIdArr.push(item.formId)
                })
                // 选项卡弹窗
                window.parent['openTabForm'](that.propValues.relstr[index].type,that.propValues.relstr[index].formId,that.propValues.relstr[index].moduleId,window.params.formid,that.propValues.relstr[index].formId);
            }else{
                if(e.target.getAttribute("class")=="btn-delete"){
                    let index=null;
                    for(let i=0;i<this.container.childs.length;i++){
                        if(this.container.childs[i].id==this.id){
                            index=i;
                            break;
                        }
                    }
                    if(index!=null){
                        this.container.childs.splice(index,1);
                        this.container.htmlDOM.removeChild(this.htmlDOM);
                        this.delWindowElem(this.propValues.id)
                        this.renderPropsPanel([],[])
                        
                    }
                }else if(e.target.tagName=='A'){
                    let index=[].indexOf.call(e.target.parentElement.children, e.target);
                    if(e.target.getAttribute("class")!='normalTabCheck'){
                        for(let i=0;i<this.htmlDOM.getElementsByTagName("a").length;i++){
                            this.htmlDOM.getElementsByTagName("a")[i].setAttribute("class",'normalTab')
                        }
                        for(let j=0;j<this.htmlDOM.getElementsByTagName("tab-content").length;j++){
                            this.htmlDOM.getElementsByTagName("tab-content")[j].setAttribute("class",'d-none')
                        }
                    }
                    e.target.setAttribute("class",'normalTabCheck')
                    this.htmlDOM.getElementsByTagName("tab-content")[index].setAttribute("class",'')
                }else{
                    let result = that.container.resetAllElemandContainer();
                    if(result){
                        that.isChecked=true;
                        that.style["border-color"]="#0DB3A6";
                        that.style["background-color"]="#EBF8FB";
                        Object.assign(that.htmlDOM.style,that.style);
                        for(let i=0;i<that.htmlDOM.children.length;i++){
                            if(that.htmlDOM.children[i].getAttribute("class") &&that.htmlDOM.children[i].getAttribute("class").indexOf('delete')!=-1)
                            that.htmlDOM.children[i].setAttribute("class",'delete')
                        }
                        // that.htmlDOM.getElementsByClassName("delete")[0].setAttribute("class",'delete')
                        window.formApp.propsPanel.propsDesc = that.getPropsDesc();
                        window.formApp.propsPanel.propValues = that.getPropValues();
                        window.formApp.propsPanel.render(that.scope);
                        return true;
                    }else{
                        return false;
                    }
                }
            }
            
           
        }

        div.ondragstart = (ev)=>{
            ev.dataTransfer.setData("Text",ev.target.id);
        }
    }
    //设置属性
    paint() {
        // for(let propName in this.propValues){
            // this.htmlDOM.setAttribute(propName,this.propValues[propName]);
        this.renderHtml(this.propValues,'prop')
        // }
        if(this.isChecked){
            this.style["border-color"]="#0DB3A6"
        }else{
            this.style["border-color"]="#fff"
        }
        Object.assign(this.htmlDOM.style,this.style);
    }
    getPropValues(){
        return this.propValues;
    }
    //获取自身选中的状态
    getChecked(){
        if(this.isChecked){
            return this;
        }else{
            return false;
        }
    }
    //重置id
    resetId(){
        this.propValues.id = Sequence.createUuid();
        this.renderHtml({id:this.propValues.id},'prop');
        this.renderHtml(this.propValues.id,'fieldid');

    }
    //校验自身
    checkSelf(){
        let name =this.propValues.name;
        if(name==''){
            alert('名称不为空');
            return false;
        }
        let numReg = new RegExp(/^\d/);
        if(numReg.test(name)){
            alert("名称不能以数字开头！");
            return false;
        }
		const regText = /^[\u4e00-\u9fa5_a-zA-Z0-9]+$/g;
        if (!regText.test(name)) {
            alert("名称不能含有非法字符！");
            return false;
        }
        
        if(name.length>22){
            alert("名称不能超过22个字符！");
            return false;
        }
        if(name.trim().length<1){
            alert("名称不能为空！");
            return false;
        }
        // 校验自身占父级百分比不能为负数
        if(this.propValues.myselfrows < 0){
            alert('自身占父级百分比不能为负数')
            return false
        }

        // yx 校验描述不能有双引号
        if(this.propValues.discript && this.propValues.discript.trim() !="" && (this.propValues.discript.indexOf("\"")>-1 || this.propValues.discript.indexOf("\“")>-1 || this.propValues.discript.indexOf("\”")>-1)){
            alert('描述不能含有双引号')
            return false
        }

        if(this.checkSpeProp){
            let result = this.checkSpeProp();
            return result;
        }
        if(this.propValues.refreshonchanged==true && this.propValues.refreshmode=='1' && this.propValues.refreshfields && this.propValues.refreshfields.length==0){
            alert("局部刷新方式下，局部刷新字段不能为空，请选择局部刷新字段！");
            return false;
        }
        return true;
        
    }

}
export default AbstractField;