import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class CommentField extends AbstractField{
    constructor(container) {
        super();
        this.scope="commentField"
        this.container = container;
        this.htmlDOM=null;
        
        this.propValues.id = Sequence.createUuid();
        
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">${this.propValues.name}</span>
        </div><div class="baseCon fieldId" fieldid='${this.propValues.id}' style="height: 30px;">
        <input type="text"  class="base-field " readonly></div>`;
        this.className="baseField";
        this.propValues.name="评论"+window.formApp.formPanel.propValues.nameIndex;
        this.propValues.width = 200; // 宽度
        this.propValues.readonlyshowvalonly = true; //只读时仅只显示值
        this.propValues.refreshonchanged = false; //刷新
        this.propValues.calculateonrefresh = true; //重计算
        this.propValues.title = "" // 评论标题
        this.propValues.discript =""; // 描述

        this.propValues.validatelibs =[]; //校验方式
        this.propValues.validaterule = ""; //校验脚本
        this.propValues.instantvalidate = false; //即时校验（新增属性）

        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.readonlyscript = ""; //只读条件脚本
        
        this.propValues.width=200;//input宽度
        
    }
    getPropsDesc() {
        return {
          "base":['myselfrows','name','width','readonlyshowvalonly','refreshonchanged','calculateonrefresh','title','discript'],
          "check":['validatelibs','validaterule','instantvalidate'],
          "hidden":['hiddenscript','hiddenvalue'],
          "hiddenprint":["hiddenprintscript","printhiddenvalue"],
          "readonly":['readonlyscript']
        }
    }
    //校验特殊属性
    checkSpeProp(){
        if(this.propValues.width<0){
            alert('宽度不能小于0')
            return false;
        }
        return true;
    }
    
}
export default CommentField;