//import FlowDiagram from './element/FlowDiagram';
import Resources from './utility/Resources';
import XMLOperate from './utility/XMLOperate';
import StringUtil from './utility/StringUtil';
import ExcelMappingDiagram from './excelmapping/ExcelMappingDiagram';

class Canvas {
  constructor(canvas) {
    this.canvas = canvas;
    this.diagram = null;
  }

  Init() {
    // console.log('test');
    if (this.canvas.getContext) {
      // var ctx = canvas.getContext('2d');
      // ctx.arc(50,50,30,0,2*Math.PI,false);
      // ctx.stroke();


      this.diagram = new ExcelMappingDiagram(this.canvas);
      this.diagram.jbInit();
      this.diagram.paint();


      // new Resources().onload(() => {
      //   this.diagram = new FlowDiagram(this.canvas);
      //   this.diagram.jbInit();
      //   this.diagram.paint();
      // });
    }
  }


  addMasterSheet(name, formName, description) {
    this.diagram.addMasterSheet(name, formName, description);
  }

  addDetailSheet(name, formName, description) {
    this.diagram.addDetailSheet(name, formName, description);
  }

  addColumn(name,fieldName,valueScript,validateRule,primaryKey,description) {
    this.diagram.addColumn(name,fieldName,valueScript,validateRule,primaryKey,description);
  }

  // addRelation() {
  //   console.log('relation');
  //   this.diagram.addRelation();
  // }

  getCurrToEdit() {
    return this.diagram.getCurrToEdit();
  }

  addStartNode() {
    this.diagram.changeStatues(FlowDiagram.ACTION_ADD_STARTNODE);
  }

  editStartNode(cn, id, name, statelabel, x, y) {
    this.diagram.editStartNode(cn, id, name, statelabel, x, y);
  }

  addCompleteNode() {
    this.diagram.changeStatues(FlowDiagram.ACTION_ADD_COMPLETENODE);
  }

  editCompleteNode(
    cn, id, name, statelabel, x, y,
    isgather, splitStartNode, isAutoArchive,
  ) {
    this.diagram.editCompleteNode(
      cn, id, name, statelabel, x, y,
      isgather, splitStartNode, isAutoArchive,
    );
  }

  addManualNode() {
    this.diagram.changeStatues(FlowDiagram.ACTION_ADD_MANUALNODE);
  }

  editManualNode(node, opts) {
    this.diagram.editManualNode(node, opts);
  }

  addAutoNode() {
    this.diagram.changeStatues(FlowDiagram.ACTION_ADD_AUTONODE);
  }

  editAutoNode(
    an, id, name, statelabel, issplit, isgather,
    autoAuditType, delayDay, delayHour, delayMinute, auditDateTime, x, y, splitStartNode,
    autoAuditTimeEditMode, auditDateTimeScript,
  ) {
    this.diagram.editAutoNode(
      an, id, name, statelabel, issplit, isgather,
      autoAuditType, delayDay, delayHour, delayMinute, auditDateTime, x, y, splitStartNode,
      autoAuditTimeEditMode, auditDateTimeScript,
    );
  }

  addSubFlow() {
    this.diagram.changeStatues(FlowDiagram.ACTION_ADD_SUBFLOW);
  }

  editSubFlow(an, opts) {
    this.diagram.editSubFlow(an, opts);
  }

  addRelation() {
    this.diagram.addRelation();
  }

  editRelation(
    rlt, id, name, condition, note, action,
    validateScript, filtercondition, editMode, processDescription,
  ) {
    this.diagram.editRelation(
      rlt, id, name, condition, note, action,
      validateScript, filtercondition, editMode, processDescription,
    );
  }

  removeElement() {
    this.diagram.changeStatues(ExcelMappingDiagram.ACTION_REMOVE);
  }

  getAllSplitNode() {
    return this.diagram.getAllSplitNode();
  }

  getAllBeforeNode(node, ispassed) {
    return this.diagram.getAllBeforeNode(node, ispassed);
  }

  getElementByID(id) {
    return this.diagram.getElementByID(id);
  }

  informationCheck() {
    return this.diagram.informationCheck();
  }

  toXML() {
    return this.diagram.toXML();
  }
  
  check() {
    return this.diagram.check();
  }
  
  XMLOperate(xml) {
    const parse = new DOMParser();
    const xmldoc = parse.parseFromString(new StringUtil().replaceXML(xml), 'text/xml');
	//console.log(xmldoc);
    new XMLOperate(xmldoc, this.diagram).parserXML();
    this.diagram.paint();
  }
}

// const OBPM = window.OBPM || {};

// OBPM.FlowDiagram = Canvas;

// window.OBPM = OBPM;

const OBPM = window.OBPM || {};

OBPM.ExcelMappingDiagram = Canvas;

window.OBPM = OBPM;
