class Resources {
  loadImage(url) {
    return new Promise((resolve, reject) => {
      const img = new Image();
      img.onload = () => resolve(img);
      img.onerror = reject;
      img.src = url;
    });
  }

  onload(callback) {
    const pr = [];

    const source = {
      // abort: "images/abort.gif",
      // abortBig: "images/abort_big.gif",
      auto: 'images/ic_auto.png',
      // autoBig: "images/auto_big.gif",
      complete: 'images/ic_complate.png',
      // completeBig: "images/complete_big.gif",
      manual: 'images/ic_manual.png',
      // manualBig: "images/manual_big.gif",
      // start: 'images/start.gif',
      start: 'images/ic_start.png',
      // startBig: "images/start_big.gif",
      subflow: 'images/ic_subflow.png',
      // subflowBig: "images/subflow_big.gif",
      // suspend: "images/suspend.gif",
      // suspendBig: "images/suspend_big.gif",
      // terminate: "images/terminate.gif",
      // terminateBig: "images/terminate_big.gif",
      gateway: 'images/ic_gateway.png',
    };

    for (const key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        const url = source[key];
        const p = this.loadImage(url).then((img) => {
          switch (key) {
            case 'start':
              Resources.IMG_START_NODE = img;
              break;
            case 'complete':
              Resources.IMG_COMPLETE_NODE = img;
              break;
            case 'gateway':
              Resources.IMG_GATEWAY_NODE = img;
              break;
            case 'auto':
              Resources.IMG_AUTO_NODE = img;
              break;
            case 'manual':
              Resources.IMG_MANUAL_NODE = img;
              break;
            case 'subflow':
              Resources.IMG_SUBFLOW_NODE = img;
              break;
            default:
              break;
          }
          return img;
        }).catch(err => console.log(err));
        pr.push(p);
      }
    }

    Promise.all(pr).then(() => {
      callback();
    });
  }
}

Resources.IMG_START_NODE = null;
Resources.IMG_COMPLETE_NODE = null;
Resources.IMG_AUTO_NODE = null;
Resources.IMG_MANUAL_NODE = null;
Resources.IMG_SUBFLOW_NODE = null;
Resources.IMG_GATEWAY_NODE = null;

Resources.FONT_METRICS = {
  width: 12,
  height: 12,
  ascent: 1,
};

Resources.COLOR = {
  white: 'rgb(255, 255, 255)',
  lightGray: 'rgb(229, 229, 229)',
  black: 'rgb(0, 0, 0)',
  lightYellow: '#FFFFE1',
  blue: 'blue',
};

export default Resources;
