/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.rbac.domain.entities.MetaEntityAbstract;
import com.bcxin.rbac.domain.entities.RoleEntity;
import com.bcxin.rbac.domain.entities.SubjectEntity;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Table(name="rbac_users")
@Entity
public class UserEntity
extends MetaEntityAbstract
implements IAggregate {
    @Id
    private String id;
    @ManyToOne
    @JoinColumn(name="subject_id", referencedColumnName="id", nullable=false)
    private SubjectEntity subject;
    @OneToMany(mappedBy="subject")
    private Collection<RoleEntity> roles;
    @Column(name="referenced_id", length=100, nullable=false)
    private String referencedId;
    @Column(name="name", length=100, nullable=false)
    private String name;

    protected UserEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static UserEntity create(SubjectEntity subject, String referencedId, String name) {
        UserEntity user = new UserEntity();
        user.setId(UUIDUtil.getShortUuid());
        user.setReferencedId(referencedId);
        user.setSubject(subject);
        user.setName(name);
        return user;
    }

    public void assignRoles(Collection<RoleEntity> roles) {
        this.setRoles(roles);
    }

    public String getId() {
        return this.id;
    }

    public SubjectEntity getSubject() {
        return this.subject;
    }

    public Collection<RoleEntity> getRoles() {
        return this.roles;
    }

    public String getReferencedId() {
        return this.referencedId;
    }

    public String getName() {
        return this.name;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setSubject(SubjectEntity subject) {
        this.subject = subject;
    }

    protected void setRoles(Collection<RoleEntity> roles) {
        this.roles = roles;
    }

    protected void setReferencedId(String referencedId) {
        this.referencedId = referencedId;
    }

    protected void setName(String name) {
        this.name = name;
    }
}

