/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.services.custom;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.utils.RedisUtil;
import com.bcxin.Infrastructures.utils.SnowFlakeUtil;
import com.bcxin.rbac.domain.RbacCustomDbReader;
import com.bcxin.rbac.domain.dtos.custom.RbacCustomRoleDto;
import com.bcxin.rbac.domain.dtos.custom.RbacPermitAppAuthRequestDto;
import com.bcxin.rbac.domain.dtos.custom.RbacPermitAppAuthResponseDto;
import com.bcxin.rbac.domain.dtos.custom.RbacPermitAppDto;
import com.bcxin.rbac.domain.dtos.custom.RbacPermitAuthRequestDto;
import com.bcxin.rbac.domain.dtos.custom.RbacPermitAuthResponseDto;
import com.bcxin.rbac.domain.dtos.custom.RbacPermitOptionAuthRequestDto;
import com.bcxin.rbac.domain.dtos.custom.RbacPermitOptionAuthResponseDto;
import com.bcxin.rbac.domain.dtos.custom.RbacPermitOptionDto;
import com.bcxin.rbac.domain.entities.RbacPermitAppEntity;
import com.bcxin.rbac.domain.entities.RbacPermitAppRoleEntity;
import com.bcxin.rbac.domain.entities.RbacPermitAppUserEntity;
import com.bcxin.rbac.domain.entities.RbacPermitOptionEntity;
import com.bcxin.rbac.domain.entities.RbacPermitOptionRoleEntity;
import com.bcxin.rbac.domain.entities.RbacPermitOptionUserEntity;
import com.bcxin.rbac.domain.repositories.custom.RbacPermitAppRepository;
import com.bcxin.rbac.domain.repositories.custom.RbacPermitAppRoleRepository;
import com.bcxin.rbac.domain.repositories.custom.RbacPermitAppUserRepository;
import com.bcxin.rbac.domain.repositories.custom.RbacPermitOptionRepository;
import com.bcxin.rbac.domain.repositories.custom.RbacPermitOptionRoleRepository;
import com.bcxin.rbac.domain.repositories.custom.RbacPermitOptionUserRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class RbacPermitAppService {
    private final RbacPermitAppRepository rbacPermitAppRepository;
    private final RbacPermitOptionRepository rbacPermitOptionRepository;
    private final RbacPermitAppRoleRepository rbacPermitAppRoleRepository;
    private final RbacPermitOptionRoleRepository rbacPermitOptionRoleRepository;
    private final RbacPermitAppUserRepository rbacPermitAppUserRepository;
    private final RbacPermitOptionUserRepository rbacPermitOptionUserRepository;
    private final RbacCustomDbReader rbacCustomDbReader;
    private final RedisUtil redisUtil;
    private final UnitWork unitWork;
    private static final String RBAC_PERMIT_APP_REDIS_KEY = "bcxin:rbac:permit:app:%s";
    private static final String RBAC_PERMIT_OPTION_REDIS_KEY = "bcxin:rbac:permit:option:%s";

    public List<RbacPermitAppDto> findOrgAppList(String organizationId) {
        Object redisCache = this.redisUtil.get(String.format(RBAC_PERMIT_APP_REDIS_KEY, organizationId));
        if (redisCache != null) {
            return JSONObject.parseArray((String)redisCache.toString(), RbacPermitAppDto.class);
        }
        List<RbacPermitAppDto> list = this.rbacCustomDbReader.findOrgAppList(organizationId);
        this.redisUtil.set(String.format(RBAC_PERMIT_APP_REDIS_KEY, organizationId), (Object)JSONObject.toJSONString(list), 300L);
        return list;
    }

    public List<RbacPermitOptionDto> findAppOptionList(Long appId) {
        Object redisCache = this.redisUtil.get(String.format(RBAC_PERMIT_OPTION_REDIS_KEY, appId));
        if (redisCache != null) {
            return JSONObject.parseArray((String)redisCache.toString(), RbacPermitOptionDto.class);
        }
        List<RbacPermitOptionDto> list = this.rbacCustomDbReader.findAppOptionList(appId);
        this.redisUtil.set(String.format(RBAC_PERMIT_OPTION_REDIS_KEY, appId), (Object)JSONObject.toJSONString(list), 300L);
        return list;
    }

    public void authPermitOption(RbacPermitAuthRequestDto request) {
        if (request.getRoleId() == null && CollectionUtil.isEmpty(request.getEmployeeIdList())) {
            throw new BadTenantException("\u89d2\u8272id\u548c\u804c\u5458id\u5217\u8868\uff0c\u81f3\u5c11\u9700\u8981\u4f20\u4e00\u4e2a");
        }
        HashMap<Long, Integer> appPermitTypeMap = new HashMap<Long, Integer>();
        List<RbacPermitAppDto> appDtoList = this.findOrgAppList(request.getOrganizationId());
        List collect = appDtoList.stream().map(RbacPermitAppDto::getAppId).collect(Collectors.toList());
        Collections.sort(collect);
        Map<Long, RbacPermitAppDto> appMap = appDtoList.stream().collect(Collectors.toMap(RbacPermitAppDto::getAppId, Function.identity()));
        HashMap<Long, RbacPermitOptionDto> optionMap = new HashMap<Long, RbacPermitOptionDto>();
        this.initAuthDataMap(request, appPermitTypeMap, appMap, optionMap);
        OperatorValueType currentOperator = AuthUtil.getCurrentOperator();
        if (request.getRoleId() != null) {
            this.authToRole(request, appPermitTypeMap, appMap, optionMap, currentOperator);
        } else {
            for (String employeeId : request.getEmployeeIdList()) {
                this.authToUser(request, employeeId, appPermitTypeMap, appMap, optionMap, currentOperator);
            }
        }
    }

    private void initAuthDataMap(RbacPermitAuthRequestDto request, Map<Long, Integer> appPermitTypeMap, Map<Long, RbacPermitAppDto> appMap, Map<Long, RbacPermitOptionDto> optionMap) {
        if (CollectionUtil.isNotEmpty(request.getAppList())) {
            for (RbacPermitAppAuthRequestDto authRequestDto : request.getAppList()) {
                if (authRequestDto.getAppId() == null) {
                    throw new BadTenantException("\u6388\u6743\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (CollectionUtil.isEmpty(authRequestDto.getOptionList())) {
                    throw new BadTenantException("\u6388\u6743\u64cd\u4f5c\u9879\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (appMap.get(authRequestDto.getAppId()) == null) {
                    throw new BadTenantException(String.format("\u6388\u6743\u5e94\u7528id:%s\uff0c\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5e94\u7528", authRequestDto.getAppId()));
                }
                List<RbacPermitOptionDto> optionDtoList = this.findAppOptionList(authRequestDto.getAppId());
                optionMap.putAll(optionDtoList.stream().collect(Collectors.toMap(RbacPermitOptionDto::getOptionId, Function.identity())));
                boolean isAuthWeb = false;
                boolean isAuthApp = false;
                for (RbacPermitOptionAuthRequestDto optionRequestDto : authRequestDto.getOptionList()) {
                    RbacPermitOptionDto optionDto = optionMap.get(optionRequestDto.getOptionId());
                    if (optionDto == null) {
                        throw new BadTenantException(String.format("\u6388\u6743\u64cd\u4f5c\u9879id:%s\uff0c\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u64cd\u4f5c\u9879", optionRequestDto.getOptionId()));
                    }
                    if (optionDto.getPermitAppId().longValue() != authRequestDto.getAppId().longValue()) {
                        throw new BadTenantException(String.format("\u6388\u6743\u5e94\u7528id:%s\u4e0e\u6388\u6743\u64cd\u4f5c\u9879id:%s\uff0c\u4e0d\u5339\u914d", authRequestDto.getAppId(), optionRequestDto.getOptionId()));
                    }
                    if (optionDto.getOptionType() == 1) {
                        isAuthWeb = true;
                        continue;
                    }
                    if (optionDto.getOptionType() != 2) continue;
                    isAuthApp = true;
                }
                if (isAuthWeb && isAuthApp) {
                    appPermitTypeMap.put(authRequestDto.getAppId(), 3);
                    continue;
                }
                if (isAuthWeb) {
                    appPermitTypeMap.put(authRequestDto.getAppId(), 1);
                    continue;
                }
                if (!isAuthApp) continue;
                appPermitTypeMap.put(authRequestDto.getAppId(), 2);
            }
        }
    }

    private void authToRole(RbacPermitAuthRequestDto request, Map<Long, Integer> appPermitTypeMap, Map<Long, RbacPermitAppDto> appMap, Map<Long, RbacPermitOptionDto> optionMap, OperatorValueType currentOperator) {
        Long roleId = request.getRoleId();
        ArrayList<RbacPermitAppRoleEntity> permitAppRoleList = new ArrayList<RbacPermitAppRoleEntity>();
        ArrayList<RbacPermitOptionRoleEntity> permitOptionRoleList = new ArrayList<RbacPermitOptionRoleEntity>();
        if (CollectionUtil.isNotEmpty(request.getAppList())) {
            for (RbacPermitAppAuthRequestDto appRequestDto : request.getAppList()) {
                RbacPermitAppDto appDto = appMap.get(appRequestDto.getAppId());
                permitAppRoleList.add(RbacPermitAppRoleEntity.create(SnowFlakeUtil.getId(), request.getOrganizationId(), appDto.getAppId(), roleId, appDto.getAppCode(), appPermitTypeMap.get(appDto.getAppId()), currentOperator.getId()));
                for (RbacPermitOptionAuthRequestDto optionRequestDto : appRequestDto.getOptionList()) {
                    RbacPermitOptionDto optionDto = optionMap.get(optionRequestDto.getOptionId());
                    permitOptionRoleList.add(RbacPermitOptionRoleEntity.create(SnowFlakeUtil.getId(), request.getOrganizationId(), optionDto.getPermitAppId(), optionDto.getOptionId(), roleId, optionDto.getAppCode(), optionDto.getOptionType(), optionDto.getOptionCode(), currentOperator.getId()));
                }
            }
        }
        this.unitWork.executeTran(() -> {
            this.rbacPermitAppRoleRepository.deleteByRbacRoleId(roleId);
            this.rbacPermitOptionRoleRepository.deleteByRbacRoleId(roleId);
            if (CollectionUtil.isNotEmpty((Collection)permitAppRoleList)) {
                for (RbacPermitAppRoleEntity appRoleEntity : permitAppRoleList) {
                    this.rbacPermitAppRoleRepository.save(appRoleEntity);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)permitOptionRoleList)) {
                for (RbacPermitOptionRoleEntity optionRoleEntity : permitOptionRoleList) {
                    this.rbacPermitOptionRoleRepository.save(optionRoleEntity);
                }
            }
        });
    }

    private void authToUser(RbacPermitAuthRequestDto request, String employeeId, Map<Long, Integer> appPermitTypeMap, Map<Long, RbacPermitAppDto> appMap, Map<Long, RbacPermitOptionDto> optionMap, OperatorValueType currentOperator) {
        ArrayList<RbacPermitAppUserEntity> permitAppUserList = new ArrayList<RbacPermitAppUserEntity>();
        ArrayList<RbacPermitOptionUserEntity> permitOptionUserList = new ArrayList<RbacPermitOptionUserEntity>();
        if (CollectionUtil.isNotEmpty(request.getAppList())) {
            for (RbacPermitAppAuthRequestDto appRequestDto : request.getAppList()) {
                RbacPermitAppDto appDto = appMap.get(appRequestDto.getAppId());
                permitAppUserList.add(RbacPermitAppUserEntity.create(SnowFlakeUtil.getId(), request.getOrganizationId(), appDto.getAppId(), employeeId, appDto.getAppCode(), appPermitTypeMap.get(appDto.getAppId()), currentOperator.getId()));
                for (RbacPermitOptionAuthRequestDto optionRequestDto : appRequestDto.getOptionList()) {
                    RbacPermitOptionDto optionDto = optionMap.get(optionRequestDto.getOptionId());
                    permitOptionUserList.add(RbacPermitOptionUserEntity.create(SnowFlakeUtil.getId(), request.getOrganizationId(), optionDto.getPermitAppId(), optionDto.getOptionId(), employeeId, optionDto.getAppCode(), optionDto.getOptionType(), optionDto.getOptionCode(), currentOperator.getId()));
                }
            }
        }
        this.unitWork.executeTran(() -> {
            this.rbacPermitAppUserRepository.deleteByTenantEmployeeId(employeeId);
            this.rbacPermitOptionUserRepository.deleteByTenantEmployeeId(employeeId);
            if (CollectionUtil.isNotEmpty((Collection)permitAppUserList)) {
                for (RbacPermitAppUserEntity appUserEntity : permitAppUserList) {
                    this.rbacPermitAppUserRepository.save(appUserEntity);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)permitOptionUserList)) {
                for (RbacPermitOptionUserEntity optionUserEntity : permitOptionUserList) {
                    this.rbacPermitOptionUserRepository.save(optionUserEntity);
                }
            }
        });
    }

    public RbacPermitAuthResponseDto getEmployeeAuthByEmployeeId(String organizationId, String employeeId) {
        List<RbacPermitOptionUserEntity> optionRoleList;
        HashSet allAppIdSet = new HashSet();
        HashSet allOptionIdSet = new HashSet();
        List<RbacPermitAppUserEntity> appRoleList = this.rbacPermitAppUserRepository.findByTenantEmployeeId(employeeId);
        if (CollectionUtil.isNotEmpty(appRoleList)) {
            allAppIdSet.addAll(appRoleList.stream().map(RbacPermitAppUserEntity::getPermitAppId).collect(Collectors.toSet()));
        }
        if (CollectionUtil.isNotEmpty(optionRoleList = this.rbacPermitOptionUserRepository.findByTenantEmployeeId(employeeId))) {
            allOptionIdSet.addAll(optionRoleList.stream().map(RbacPermitOptionUserEntity::getPermitOptionId).collect(Collectors.toSet()));
        }
        ArrayList<RbacPermitAppAuthResponseDto> appResponseList = new ArrayList<RbacPermitAppAuthResponseDto>();
        if (allAppIdSet.size() > 0 && allOptionIdSet.size() > 0) {
            List<RbacPermitAppEntity> appList = this.rbacPermitAppRepository.findByIds(new ArrayList<Long>(allAppIdSet));
            List<RbacPermitOptionEntity> optionList = this.rbacPermitOptionRepository.findByIds(new ArrayList<Long>(allOptionIdSet));
            Map<Long, List<RbacPermitOptionEntity>> app_optionMap = optionList.stream().collect(Collectors.groupingBy(RbacPermitOptionEntity::getPermitAppId));
            for (RbacPermitAppEntity app : appList) {
                ArrayList<RbacPermitOptionAuthResponseDto> optionResponseList = new ArrayList<RbacPermitOptionAuthResponseDto>();
                if (app_optionMap.get(app.getId()) != null) {
                    for (RbacPermitOptionEntity option : app_optionMap.get(app.getId())) {
                        optionResponseList.add(new RbacPermitOptionAuthResponseDto(option.getId(), option.getCategory(), option.getOptionType(), option.getOptionCode(), option.getOptionName()));
                    }
                }
                appResponseList.add(new RbacPermitAppAuthResponseDto(app.getId(), app.getAppCode(), app.getAppName(), app.getAppLogo(), app.getCategory(), optionResponseList));
            }
        }
        return new RbacPermitAuthResponseDto(appResponseList);
    }

    public RbacPermitAuthResponseDto getRoleAuthByRoleId(String organizationId, Long roleId) {
        List<Long> roleIds = Collections.singletonList(roleId);
        List<RbacPermitAppRoleEntity> appRoleList = this.rbacPermitAppRoleRepository.findByRbacRoleIdIn(roleIds);
        List<RbacPermitOptionRoleEntity> optionRoleList = this.rbacPermitOptionRoleRepository.findByRbacRoleIdIn(roleIds);
        Set allAppIdSet = appRoleList.stream().map(RbacPermitAppRoleEntity::getPermitAppId).collect(Collectors.toSet());
        Set allOptionIdSet = optionRoleList.stream().map(RbacPermitOptionRoleEntity::getPermitOptionId).collect(Collectors.toSet());
        ArrayList<RbacPermitAppAuthResponseDto> appResponseList = new ArrayList<RbacPermitAppAuthResponseDto>();
        if (allAppIdSet.size() > 0 && allOptionIdSet.size() > 0) {
            List<RbacPermitAppEntity> appList = this.rbacPermitAppRepository.findByIds(new ArrayList<Long>(allAppIdSet));
            List<RbacPermitOptionEntity> optionList = this.rbacPermitOptionRepository.findByIds(new ArrayList<Long>(allOptionIdSet));
            Map<Long, List<RbacPermitOptionEntity>> app_optionMap = optionList.stream().collect(Collectors.groupingBy(RbacPermitOptionEntity::getPermitAppId));
            for (RbacPermitAppEntity app : appList) {
                ArrayList<RbacPermitOptionAuthResponseDto> optionResponseList = new ArrayList<RbacPermitOptionAuthResponseDto>();
                if (app_optionMap.get(app.getId()) != null) {
                    for (RbacPermitOptionEntity option : app_optionMap.get(app.getId())) {
                        optionResponseList.add(new RbacPermitOptionAuthResponseDto(option.getId(), option.getCategory(), option.getOptionType(), option.getOptionCode(), option.getOptionName()));
                    }
                }
                appResponseList.add(new RbacPermitAppAuthResponseDto(app.getId(), app.getAppCode(), app.getAppName(), app.getAppLogo(), app.getCategory(), optionResponseList));
            }
        }
        return new RbacPermitAuthResponseDto(appResponseList);
    }

    public RbacPermitAuthResponseDto getAllAuthByEmployeeId(String organizationId, String employeeId) {
        List<RbacPermitOptionUserEntity> optionRoleList;
        List<RbacPermitAppUserEntity> appRoleList;
        HashSet allAppIdSet = new HashSet();
        HashSet allOptionIdSet = new HashSet();
        List<RbacCustomRoleDto> roleList = this.rbacCustomDbReader.findOrgRoleList(organizationId, null, employeeId);
        if (CollectionUtil.isNotEmpty(roleList)) {
            List<Long> roleIds = roleList.stream().map(RbacCustomRoleDto::getId).collect(Collectors.toList());
            List<RbacPermitAppRoleEntity> appRoleList2 = this.rbacPermitAppRoleRepository.findByRbacRoleIdIn(roleIds);
            List<RbacPermitOptionRoleEntity> optionRoleList2 = this.rbacPermitOptionRoleRepository.findByRbacRoleIdIn(roleIds);
            allAppIdSet.addAll(appRoleList2.stream().map(RbacPermitAppRoleEntity::getPermitAppId).collect(Collectors.toSet()));
            allOptionIdSet.addAll(optionRoleList2.stream().map(RbacPermitOptionRoleEntity::getPermitOptionId).collect(Collectors.toSet()));
        }
        if (CollectionUtil.isNotEmpty(appRoleList = this.rbacPermitAppUserRepository.findByTenantEmployeeId(employeeId))) {
            allAppIdSet.addAll(appRoleList.stream().map(RbacPermitAppUserEntity::getPermitAppId).collect(Collectors.toSet()));
        }
        if (CollectionUtil.isNotEmpty(optionRoleList = this.rbacPermitOptionUserRepository.findByTenantEmployeeId(employeeId))) {
            allOptionIdSet.addAll(optionRoleList.stream().map(RbacPermitOptionUserEntity::getPermitOptionId).collect(Collectors.toSet()));
        }
        ArrayList<RbacPermitAppAuthResponseDto> appResponseList = new ArrayList<RbacPermitAppAuthResponseDto>();
        if (allAppIdSet.size() > 0 && allOptionIdSet.size() > 0) {
            List<RbacPermitAppEntity> appList = this.rbacPermitAppRepository.findByIds(new ArrayList<Long>(allAppIdSet));
            List<RbacPermitOptionEntity> optionList = this.rbacPermitOptionRepository.findByIds(new ArrayList<Long>(allOptionIdSet));
            Map<Long, List<RbacPermitOptionEntity>> app_optionMap = optionList.stream().collect(Collectors.groupingBy(RbacPermitOptionEntity::getPermitAppId));
            for (RbacPermitAppEntity app : appList) {
                ArrayList<RbacPermitOptionAuthResponseDto> optionResponseList = new ArrayList<RbacPermitOptionAuthResponseDto>();
                if (app_optionMap.get(app.getId()) != null) {
                    for (RbacPermitOptionEntity option : app_optionMap.get(app.getId())) {
                        optionResponseList.add(new RbacPermitOptionAuthResponseDto(option.getId(), option.getCategory(), option.getOptionType(), option.getOptionCode(), option.getOptionName()));
                    }
                }
                appResponseList.add(new RbacPermitAppAuthResponseDto(app.getId(), app.getAppCode(), app.getAppName(), app.getAppLogo(), app.getCategory(), optionResponseList));
            }
        }
        return new RbacPermitAuthResponseDto(appResponseList);
    }

    public RbacPermitAppService(RbacPermitAppRepository rbacPermitAppRepository, RbacPermitOptionRepository rbacPermitOptionRepository, RbacPermitAppRoleRepository rbacPermitAppRoleRepository, RbacPermitOptionRoleRepository rbacPermitOptionRoleRepository, RbacPermitAppUserRepository rbacPermitAppUserRepository, RbacPermitOptionUserRepository rbacPermitOptionUserRepository, RbacCustomDbReader rbacCustomDbReader, RedisUtil redisUtil, UnitWork unitWork) {
        this.rbacPermitAppRepository = rbacPermitAppRepository;
        this.rbacPermitOptionRepository = rbacPermitOptionRepository;
        this.rbacPermitAppRoleRepository = rbacPermitAppRoleRepository;
        this.rbacPermitOptionRoleRepository = rbacPermitOptionRoleRepository;
        this.rbacPermitAppUserRepository = rbacPermitAppUserRepository;
        this.rbacPermitOptionUserRepository = rbacPermitOptionUserRepository;
        this.rbacCustomDbReader = rbacCustomDbReader;
        this.redisUtil = redisUtil;
        this.unitWork = unitWork;
    }
}

