/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.services.custom;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.Infrastructures.Pageable;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.utils.SnowFlakeUtil;
import com.bcxin.rbac.domain.RbacCustomDbReader;
import com.bcxin.rbac.domain.dtos.custom.RbacCustomRoleDto;
import com.bcxin.rbac.domain.dtos.custom.RbacCustomRoleUserDto;
import com.bcxin.rbac.domain.dtos.custom.RbacUserDto;
import com.bcxin.rbac.domain.dtos.custom.RbacUserSearchDto;
import com.bcxin.rbac.domain.entities.RbacCustomRoleEntity;
import com.bcxin.rbac.domain.entities.RbacCustomRoleUserEntity;
import com.bcxin.rbac.domain.entities.RbacPermitAppRoleEntity;
import com.bcxin.rbac.domain.entities.RbacPermitOptionRoleEntity;
import com.bcxin.rbac.domain.repositories.custom.RbacCustomRoleRepository;
import com.bcxin.rbac.domain.repositories.custom.RbacCustomRoleUserRepository;
import com.bcxin.rbac.domain.repositories.custom.RbacPermitAppRoleRepository;
import com.bcxin.rbac.domain.repositories.custom.RbacPermitOptionRoleRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class RbacCustomRoleService {
    private final RbacCustomRoleRepository rbacCustomRoleRepository;
    private final RbacCustomRoleUserRepository rbacCustomRoleUserRepository;
    private final RbacPermitAppRoleRepository rbacPermitAppRoleRepository;
    private final RbacPermitOptionRoleRepository rbacPermitOptionRoleRepository;
    private final RbacCustomDbReader rbacCustomDbReader;
    private final UnitWork unitWork;

    public List<RbacCustomRoleDto> findOrgRoleList(String organizationId, String roleName, String employeeId) {
        return this.rbacCustomDbReader.findOrgRoleList(organizationId, roleName, employeeId);
    }

    public Pageable<RbacUserDto> getRbacUserDtoList(RbacUserSearchDto searchDto) {
        return this.rbacCustomDbReader.getRbacUserDtoList(searchDto);
    }

    public void addRole(String organizationId, String roleName, String remark, Integer seq) {
        Optional<RbacCustomRoleEntity> exist1 = this.rbacCustomRoleRepository.findByOrganizationIdAndRoleName(organizationId, roleName);
        if (exist1.isPresent()) {
            throw new BadTenantException("\u8be5\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        Optional<RbacCustomRoleEntity> exist2 = this.rbacCustomRoleRepository.findByOrganizationIdAndSeq(organizationId, seq);
        if (exist2.isPresent()) {
            throw new BadTenantException("\u8be5\u6392\u5e8f\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        OperatorValueType currentOperator = AuthUtil.getCurrentOperator();
        RbacCustomRoleEntity entity = RbacCustomRoleEntity.create(SnowFlakeUtil.getId(), organizationId, roleName, remark, seq, currentOperator.getId());
        this.unitWork.executeTran(() -> this.rbacCustomRoleRepository.save(entity));
    }

    public void editRole(String organizationId, Long id, String roleName, String remark, Integer seq) {
        Optional entity = this.rbacCustomRoleRepository.findById(id);
        if (!entity.isPresent()) {
            throw new BadTenantException("\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        Optional<RbacCustomRoleEntity> exist1 = this.rbacCustomRoleRepository.findByOrganizationIdAndRoleName(organizationId, roleName);
        if (exist1.isPresent() && exist1.get().getId().longValue() != id.longValue()) {
            throw new BadTenantException("\u8be5\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        Optional<RbacCustomRoleEntity> exist2 = this.rbacCustomRoleRepository.findByOrganizationIdAndSeq(organizationId, seq);
        if (exist2.isPresent() && exist2.get().getId().longValue() != id.longValue()) {
            throw new BadTenantException("\u8be5\u6392\u5e8f\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        OperatorValueType currentOperator = AuthUtil.getCurrentOperator();
        RbacCustomRoleEntity customRoleEntity = (RbacCustomRoleEntity)((Object)entity.get());
        customRoleEntity.update(roleName, remark, seq, currentOperator.getId());
        this.unitWork.executeTran(() -> this.rbacCustomRoleRepository.save(customRoleEntity));
    }

    public RbacCustomRoleDto findById(Long id) {
        Optional entity = this.rbacCustomRoleRepository.findById(id);
        if (!entity.isPresent()) {
            throw new BadTenantException("\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        RbacCustomRoleDto dto = new RbacCustomRoleDto();
        BeanUtils.copyProperties(entity.get(), (Object)dto);
        return dto;
    }

    public void copyRole(Long sourceId, String roleName, String remark, Integer seq) {
        Optional source = this.rbacCustomRoleRepository.findById(sourceId);
        if (!source.isPresent()) {
            throw new BadTenantException("\u539f\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        RbacCustomRoleEntity sourceEntity = (RbacCustomRoleEntity)((Object)source.get());
        String organizationId = sourceEntity.getOrganizationId();
        Optional<RbacCustomRoleEntity> exist1 = this.rbacCustomRoleRepository.findByOrganizationIdAndRoleName(organizationId, roleName);
        if (exist1.isPresent()) {
            throw new BadTenantException("\u8be5\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        Optional<RbacCustomRoleEntity> exist2 = this.rbacCustomRoleRepository.findByOrganizationIdAndSeq(organizationId, seq);
        if (exist2.isPresent()) {
            throw new BadTenantException("\u8be5\u6392\u5e8f\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        OperatorValueType currentOperator = AuthUtil.getCurrentOperator();
        RbacCustomRoleEntity entity = RbacCustomRoleEntity.create(SnowFlakeUtil.getId(), organizationId, roleName, remark, seq, currentOperator.getId());
        ArrayList<RbacPermitAppRoleEntity> permitAppRoleEntityList = new ArrayList<RbacPermitAppRoleEntity>();
        List<RbacPermitAppRoleEntity> sourcePermitAppRoleEntityList = this.rbacPermitAppRoleRepository.findByRbacRoleId(sourceId);
        if (CollectionUtil.isNotEmpty(sourcePermitAppRoleEntityList)) {
            for (RbacPermitAppRoleEntity appRoleEntity : sourcePermitAppRoleEntityList) {
                permitAppRoleEntityList.add(RbacPermitAppRoleEntity.create(SnowFlakeUtil.getId(), appRoleEntity.getOrganizationId(), appRoleEntity.getPermitAppId(), entity.getId(), appRoleEntity.getAppCode(), appRoleEntity.getPermitType(), currentOperator.getId()));
            }
        }
        ArrayList<RbacPermitOptionRoleEntity> permitOptionRoleEntityList = new ArrayList<RbacPermitOptionRoleEntity>();
        List<RbacPermitOptionRoleEntity> sourcePermitOptionRoleEntityList = this.rbacPermitOptionRoleRepository.findByRbacRoleId(sourceId);
        if (CollectionUtil.isNotEmpty(sourcePermitOptionRoleEntityList)) {
            for (RbacPermitOptionRoleEntity optionRoleEntity : sourcePermitOptionRoleEntityList) {
                permitOptionRoleEntityList.add(RbacPermitOptionRoleEntity.create(SnowFlakeUtil.getId(), optionRoleEntity.getOrganizationId(), optionRoleEntity.getPermitAppId(), optionRoleEntity.getPermitOptionId(), entity.getId(), optionRoleEntity.getAppCode(), optionRoleEntity.getOptionType(), optionRoleEntity.getOptionCode(), currentOperator.getId()));
            }
        }
        this.unitWork.executeTran(() -> {
            this.rbacCustomRoleRepository.save(entity);
            if (CollectionUtil.isNotEmpty((Collection)permitAppRoleEntityList)) {
                for (RbacPermitAppRoleEntity rbacPermitAppRoleEntity : permitAppRoleEntityList) {
                    this.rbacPermitAppRoleRepository.save(rbacPermitAppRoleEntity);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)permitOptionRoleEntityList)) {
                for (RbacPermitOptionRoleEntity rbacPermitOptionRoleEntity : permitOptionRoleEntityList) {
                    this.rbacPermitOptionRoleRepository.save(rbacPermitOptionRoleEntity);
                }
            }
        });
    }

    public void deleteRole(List<Long> idList) {
        ArrayList deleteList = new ArrayList();
        if (CollectionUtil.isEmpty(idList)) {
            throw new BadTenantException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Long id : idList) {
            Optional entity = this.rbacCustomRoleRepository.findById(id);
            if (!entity.isPresent()) {
                throw new BadTenantException("\u89d2\u8272\u4e0d\u5b58\u5728");
            }
            long userCount = this.rbacCustomRoleUserRepository.findCountByRbacRoleId(id);
            if (userCount > 0L) {
                throw new BadTenantException("\u8be5\u89d2\u8272\u8fd8\u6709\u6210\u5458\u5173\u8054\uff0c\u8bf7\u5148\u79fb\u9664");
            }
            deleteList.add(entity.get());
        }
        if (CollectionUtil.isNotEmpty(deleteList)) {
            this.unitWork.executeTran(() -> {
                for (RbacCustomRoleEntity entity : deleteList) {
                    this.rbacCustomRoleRepository.delete(entity);
                }
            });
        }
    }

    public void addRoleAndUsers(Long roleId, List<String> employeeIdList) {
        if (roleId == null) {
            throw new BadTenantException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(employeeIdList)) {
            throw new BadTenantException("\u804c\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Optional role = this.rbacCustomRoleRepository.findById(roleId);
        if (!role.isPresent()) {
            throw new BadTenantException("\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        OperatorValueType currentOperator = AuthUtil.getCurrentOperator();
        ArrayList<RbacCustomRoleUserEntity> insertList = new ArrayList<RbacCustomRoleUserEntity>();
        for (String employeeId : employeeIdList) {
            Optional<RbacCustomRoleUserEntity> roleUserExist = this.rbacCustomRoleUserRepository.findByRbacRoleIdAndTenantEmployeeId(roleId, employeeId);
            if (roleUserExist.isPresent()) continue;
            RbacCustomRoleUserEntity entity = RbacCustomRoleUserEntity.create(SnowFlakeUtil.getId(), ((RbacCustomRoleEntity)((Object)role.get())).getOrganizationId(), roleId, employeeId, currentOperator.getId());
            insertList.add(entity);
        }
        if (CollectionUtil.isNotEmpty(insertList)) {
            this.unitWork.executeTran(() -> {
                for (RbacCustomRoleUserEntity entity : insertList) {
                    this.rbacCustomRoleUserRepository.save(entity);
                }
            });
        }
    }

    public void addUserAndRoles(String employeeId, List<Long> roleIdList) {
        if (StringUtils.isBlank((CharSequence)employeeId)) {
            throw new BadTenantException("\u804c\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(roleIdList)) {
            throw new BadTenantException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OperatorValueType currentOperator = AuthUtil.getCurrentOperator();
        ArrayList<RbacCustomRoleUserEntity> insertList = new ArrayList<RbacCustomRoleUserEntity>();
        for (Long roleId : roleIdList) {
            Optional role = this.rbacCustomRoleRepository.findById(roleId);
            if (!role.isPresent()) {
                throw new BadTenantException("\u89d2\u8272\u4e0d\u5b58\u5728");
            }
            Optional<RbacCustomRoleUserEntity> roleUserExist = this.rbacCustomRoleUserRepository.findByRbacRoleIdAndTenantEmployeeId(roleId, employeeId);
            if (roleUserExist.isPresent()) continue;
            RbacCustomRoleUserEntity entity = RbacCustomRoleUserEntity.create(SnowFlakeUtil.getId(), ((RbacCustomRoleEntity)((Object)role.get())).getOrganizationId(), roleId, employeeId, currentOperator.getId());
            insertList.add(entity);
        }
        if (CollectionUtil.isNotEmpty(insertList)) {
            this.unitWork.executeTran(() -> {
                for (RbacCustomRoleUserEntity entity : insertList) {
                    this.rbacCustomRoleUserRepository.save(entity);
                }
            });
        }
    }

    public void addUsersAndRoles(List<String> employeeIdList, List<Long> roleIdList) {
        if (CollectionUtil.isEmpty(employeeIdList)) {
            throw new BadTenantException("\u804c\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(roleIdList)) {
            throw new BadTenantException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OperatorValueType currentOperator = AuthUtil.getCurrentOperator();
        ArrayList<RbacCustomRoleUserEntity> insertList = new ArrayList<RbacCustomRoleUserEntity>();
        for (Long roleId : roleIdList) {
            Optional role = this.rbacCustomRoleRepository.findById(roleId);
            if (!role.isPresent()) {
                throw new BadTenantException("\u89d2\u8272\u4e0d\u5b58\u5728");
            }
            for (String employeeId : employeeIdList) {
                Optional<RbacCustomRoleUserEntity> roleUserExist = this.rbacCustomRoleUserRepository.findByRbacRoleIdAndTenantEmployeeId(roleId, employeeId);
                if (roleUserExist.isPresent()) continue;
                RbacCustomRoleUserEntity entity = RbacCustomRoleUserEntity.create(SnowFlakeUtil.getId(), ((RbacCustomRoleEntity)((Object)role.get())).getOrganizationId(), roleId, employeeId, currentOperator.getId());
                insertList.add(entity);
            }
        }
        if (CollectionUtil.isNotEmpty(insertList)) {
            this.unitWork.executeTran(() -> {
                for (RbacCustomRoleUserEntity entity : insertList) {
                    this.rbacCustomRoleUserRepository.save(entity);
                }
            });
        }
    }

    public void deleteRoleAndUsers(Long roleId, List<String> employeeIdList) {
        if (roleId == null) {
            throw new BadTenantException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(employeeIdList)) {
            throw new BadTenantException("\u804c\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Optional role = this.rbacCustomRoleRepository.findById(roleId);
        if (!role.isPresent()) {
            throw new BadTenantException("\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        ArrayList deleteList = new ArrayList();
        for (String employeeId : employeeIdList) {
            Optional<RbacCustomRoleUserEntity> roleUserExist = this.rbacCustomRoleUserRepository.findByRbacRoleIdAndTenantEmployeeId(roleId, employeeId);
            roleUserExist.ifPresent(deleteList::add);
        }
        if (CollectionUtil.isNotEmpty(deleteList)) {
            this.unitWork.executeTran(() -> {
                for (RbacCustomRoleUserEntity entity : deleteList) {
                    this.rbacCustomRoleUserRepository.delete(entity);
                }
            });
        }
    }

    public void deleteUserAndRoles(String employeeId, List<Long> roleIdList) {
        if (StringUtils.isBlank((CharSequence)employeeId)) {
            throw new BadTenantException("\u804c\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(roleIdList)) {
            throw new BadTenantException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList deleteList = new ArrayList();
        for (Long roleId : roleIdList) {
            Optional<RbacCustomRoleUserEntity> roleUserExist = this.rbacCustomRoleUserRepository.findByRbacRoleIdAndTenantEmployeeId(roleId, employeeId);
            roleUserExist.ifPresent(deleteList::add);
        }
        if (CollectionUtil.isNotEmpty(deleteList)) {
            this.unitWork.executeTran(() -> {
                for (RbacCustomRoleUserEntity entity : deleteList) {
                    this.rbacCustomRoleUserRepository.delete(entity);
                }
            });
        }
    }

    public List<RbacCustomRoleUserDto> findRoleUserListByRoleIdAndEmployeeIdList(Long roleId, List<String> employeeIdList) {
        ArrayList<RbacCustomRoleUserDto> resultList = new ArrayList<RbacCustomRoleUserDto>();
        List<RbacCustomRoleUserEntity> roleUserEntityList = this.rbacCustomRoleUserRepository.findListByRbacRoleIdAndEmployeeIdList(roleId, employeeIdList);
        if (CollectionUtil.isNotEmpty(roleUserEntityList)) {
            for (RbacCustomRoleUserEntity roleUserEntity : roleUserEntityList) {
                resultList.add(new RbacCustomRoleUserDto(roleUserEntity.getId(), roleUserEntity.getRbacRoleId(), roleUserEntity.getTenantEmployeeId(), roleUserEntity.getCreateTime()));
            }
        }
        return resultList;
    }

    public List<Map<String, String>> importMember(String organizationId, Long roleId, List<Map<String, String>> importDataList) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (CollectionUtil.isEmpty(importDataList)) {
            throw new BadTenantException("\u5bfc\u5165\u7684\u8868\u683c\u6570\u636e\u4e3a\u7a7a");
        }
        List<String> names = importDataList.stream().map(data -> (String)data.get("name")).collect(Collectors.toList());
        List<RbacUserDto> rbacUserDtoList = this.rbacCustomDbReader.getRbacUserDtoList(organizationId, names);
        Map<String, List<RbacUserDto>> userDtoListMap = rbacUserDtoList.stream().collect(Collectors.groupingBy(RbacUserDto::getUserName));
        List<RbacCustomRoleUserEntity> roleUserList = this.rbacCustomRoleUserRepository.findByRbacRoleId(roleId);
        List existEmployeeIdList = roleUserList.stream().map(RbacCustomRoleUserEntity::getTenantEmployeeId).collect(Collectors.toList());
        ArrayList<String> employeeIdList = new ArrayList<String>();
        for (Map<String, String> data2 : importDataList) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            String name = data2.get("name");
            String telephone = data2.get("telephone");
            resultMap.put("paramName", name);
            resultMap.put("paramTelephone", telephone);
            List<RbacUserDto> dtoList = userDtoListMap.get(name);
            if (CollectionUtil.isEmpty(dtoList)) {
                resultMap.put("result", "\u8be5\u7528\u6237\u4e0d\u5728\u672c\u4f01\u4e1a\u804c\u5458\u5217\u8868\u91cc\u9762");
            } else if (dtoList.size() > 1) {
                if (StringUtils.isBlank((CharSequence)telephone)) {
                    resultMap.put("result", "\u8be5\u7528\u6237\u59d3\u540d\u51fa\u73b0\u91cd\u590d\uff0c\u4e14\u672a\u586b\u624b\u673a\u53f7\uff0c\u65e0\u6cd5\u5bfc\u5165\uff0c\u8bf7\u5148\u586b\u5199\u624b\u673a\u53f7");
                } else {
                    Optional<RbacUserDto> userDto = dtoList.stream().filter(dto -> dto.getMobile().equals(telephone)).findFirst();
                    if (userDto.isPresent()) {
                        String employeeId = userDto.get().getEmployeeId();
                        if (existEmployeeIdList.contains(employeeId)) {
                            resultMap.put("result", "\u8be5\u7528\u6237\u5df2\u6709\u8be5\u89d2\u8272\uff0c\u65e0\u9700\u91cd\u590d\u5bfc\u5165");
                        } else {
                            employeeIdList.add(employeeId);
                            resultMap.put("result", "\u5bfc\u5165\u6210\u529f");
                        }
                    } else {
                        resultMap.put("result", "\u8be5\u7528\u6237\u59d3\u540d\u51fa\u73b0\u91cd\u590d\uff0c\u4e14\u624b\u673a\u53f7\u5339\u914d\u4e0d\u4e0a\uff0c\u8bf7\u786e\u8ba4\u624b\u673a\u53f7\u662f\u5426\u6b63\u786e");
                    }
                }
            } else {
                String employeeId = dtoList.get(0).getEmployeeId();
                if (existEmployeeIdList.contains(employeeId)) {
                    resultMap.put("result", "\u8be5\u7528\u6237\u5df2\u6709\u8be5\u89d2\u8272\uff0c\u65e0\u9700\u91cd\u590d\u5bfc\u5165");
                } else {
                    employeeIdList.add(employeeId);
                    resultMap.put("result", "\u5bfc\u5165\u6210\u529f");
                }
            }
            result.add(resultMap);
        }
        if (CollectionUtil.isNotEmpty(employeeIdList)) {
            this.addRoleAndUsers(roleId, employeeIdList);
        }
        return result;
    }

    public RbacCustomRoleService(RbacCustomRoleRepository rbacCustomRoleRepository, RbacCustomRoleUserRepository rbacCustomRoleUserRepository, RbacPermitAppRoleRepository rbacPermitAppRoleRepository, RbacPermitOptionRoleRepository rbacPermitOptionRoleRepository, RbacCustomDbReader rbacCustomDbReader, UnitWork unitWork) {
        this.rbacCustomRoleRepository = rbacCustomRoleRepository;
        this.rbacCustomRoleUserRepository = rbacCustomRoleUserRepository;
        this.rbacPermitAppRoleRepository = rbacPermitAppRoleRepository;
        this.rbacPermitOptionRoleRepository = rbacPermitOptionRoleRepository;
        this.rbacCustomDbReader = rbacCustomDbReader;
        this.unitWork = unitWork;
    }
}

