/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.rm;

import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.rbac.domain.entities.MetaEntityAbstract;
import com.bcxin.rbac.domain.rm.GroupEntity;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Table
@Entity
public class FunctionEntity
extends MetaEntityAbstract {
    @Id
    private String id;
    @Column(name="name", length=500, nullable=false)
    private String name;
    @Column(nullable=false, name="online")
    private TrueFalseStatus online;
    @Column(name="category", length=100, nullable=false)
    private String category;
    @ManyToOne
    @JoinColumn(name="group_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_function_group_id", value=ConstraintMode.CONSTRAINT))
    private GroupEntity group;

    protected FunctionEntity() {
        this.setCategory("FUNCTION");
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static FunctionEntity create(String name, String metaId, boolean online) {
        FunctionEntity function = new FunctionEntity();
        function.setId(UUIDUtil.getShortUuid());
        function.setMetaId(metaId);
        function.setName(name);
        function.setOnline(online ? TrueFalseStatus.True : TrueFalseStatus.False);
        return function;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TrueFalseStatus getOnline() {
        return this.online;
    }

    public String getCategory() {
        return this.category;
    }

    public GroupEntity getGroup() {
        return this.group;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setOnline(TrueFalseStatus online) {
        this.online = online;
    }

    protected void setCategory(String category) {
        this.category = category;
    }

    protected void setGroup(GroupEntity group) {
        this.group = group;
    }
}

