/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.autodownloadupload.controller;

import cn.hutool.core.io.FileUtil;
import com.bcxin.autodownloadupload.common.utils.FileUtils;
import com.bcxin.autodownloadupload.dtos.ChangeLogsRequestDto;
import com.bcxin.autodownloadupload.dtos.FerryTaskPullResult;
import com.bcxin.autodownloadupload.entity.PullRecord;
import com.bcxin.autodownloadupload.service.PullDataService;
import com.bcxin.autodownloadupload.service.PullRecordService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pull/data"})
public class PullDataController {
    private static final Logger log = LoggerFactory.getLogger(PullDataController.class);
    @Autowired
    private PullDataService pullDataService;
    @Autowired
    private PullRecordService pullRecordService;

    @GetMapping(value={"/oldDataProcessor/{beginEnd}"})
    public void oldDataProcessor(@PathVariable(value="beginEnd") String beginEnd) {
        String[] split = beginEnd.split("-");
        this.pullDataService.oldDataProcessor(Long.valueOf(Long.parseLong(split[0])), Long.valueOf(Long.parseLong(split[1])));
    }

    @RequestMapping(value={"/manual"}, method={RequestMethod.GET, RequestMethod.POST})
    public Map<String, Object> manual(@RequestBody ChangeLogsRequestDto requestDto) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.pullDataService.pullDataAsync(requestDto, 1);
        resultMap.put("code", 200);
        resultMap.put("message", "\u8c03\u7528\u6210\u529f");
        return resultMap;
    }

    @GetMapping(value={"/download/{requestId}"})
    public void downloadByRequestId(@PathVariable(value="requestId") String requestId, HttpServletResponse response) throws IOException {
        log.info("\u62c9\u53d6\u6570\u636ezip\u5305\u4e0b\u8f7d\uff0crequestId:{}", (Object)requestId);
        PullRecord pullRecord = this.pullRecordService.getByRequestId(requestId);
        if (pullRecord == null || StringUtils.isBlank((CharSequence)pullRecord.getCompleteZipPath()) || !FileUtil.exist((String)pullRecord.getCompleteZipPath())) {
            response.setContentType("text/html; charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.flush();
            out.println("<script defer='defer' type='text/javascript'>");
            out.println("alert('\u65e0zip\u5305\u4e0b\u8f7d\uff0c\u8bf7\u786e\u8ba4\u524d\u4e00\u5929\u662f\u5426\u4ea7\u751f\u53d8\u66f4\u6570\u636e\uff0c\u5982\u679c\u6ca1\u6709\u4ea7\u751f\u53d8\u66f4\u6570\u636e\uff0c\u5219\u4e0d\u4f1a\u751f\u6210zip\u5305');");
            out.println("</script>");
            return;
        }
        FileUtils.responseWithFile((String)pullRecord.getCompleteZipPath(), (HttpServletResponse)response);
    }

    @PostMapping(value={"/query/result"})
    public FerryTaskPullResult queryResult(@RequestBody ChangeLogsRequestDto requestDto) {
        return this.pullDataService.queryBjFerryPullResult(requestDto.getBjFerryTaskId());
    }
}

