/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.autodownloadupload.controller;

import cn.hutool.core.io.FileUtil;
import com.bcxin.autodownloadupload.common.utils.FileUtils;
import com.bcxin.autodownloadupload.dtos.FerryReceiveTaskPushResult;
import com.bcxin.autodownloadupload.entity.PushRecord;
import com.bcxin.autodownloadupload.service.PushDataService;
import com.bcxin.autodownloadupload.service.PushRecordService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/push/data"})
public class PushDataController {
    private static final Logger log = LoggerFactory.getLogger(PushDataController.class);
    @Autowired
    private PushDataService pushDataService;
    @Autowired
    private PushRecordService pushRecordService;

    @GetMapping(value={"/{requestId}"})
    public Map<String, Object> pushData(@PathVariable(value="requestId") String requestId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        PushRecord exist = this.pushRecordService.getByRequestId(requestId);
        if (exist != null) {
            log.error("\u5f53\u524drequestId\uff1a{}\uff0c\u5df2\u7ecf\u6267\u884c\u4e86\uff0c\u65e0\u9700\u91cd\u590d\u6267\u884c", (Object)requestId);
            resultMap.put("code", "100000");
            resultMap.put("message", "\u5f53\u524drequestId\uff1a" + requestId + "\uff0c\u5df2\u7ecf\u6267\u884c\u4e86\uff0c\u65e0\u9700\u91cd\u590d\u6267\u884c");
            return resultMap;
        }
        PushRecord pushRecord = this.pushDataService.pushData(requestId);
        resultMap.put("code", "200");
        resultMap.put("message", pushRecord.getSqlResult() + "\r\n" + pushRecord.getUploadResult());
        return resultMap;
    }

    @PostMapping(value={"/{requestId}"})
    public Map<String, Object> pushDataPost(@PathVariable(value="requestId") String requestId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        PushRecord exist = this.pushRecordService.getByRequestId(requestId);
        if (exist != null) {
            log.error("\u5f53\u524drequestId\uff1a{}\uff0c\u5df2\u7ecf\u6267\u884c\u4e86\uff0c\u65e0\u9700\u91cd\u590d\u6267\u884c", (Object)requestId);
            resultMap.put("code", "100000");
            resultMap.put("message", "\u5f53\u524drequestId\uff1a" + requestId + "\uff0c\u5df2\u7ecf\u6267\u884c\u4e86\uff0c\u65e0\u9700\u91cd\u590d\u6267\u884c");
            return resultMap;
        }
        this.pushDataService.pushDataAsync(requestId);
        resultMap.put("code", "200");
        resultMap.put("message", "\u63a8\u9001\u6587\u4ef6\u6210\u529f");
        return resultMap;
    }

    @GetMapping(value={"/download/error/{requestId}"})
    public void downloadErrorByRequestId(@PathVariable(value="requestId") String requestId, HttpServletResponse response) throws IOException {
        log.info("\u63a8\u9001\u9519\u8bef\u8bb0\u5f55txt\u4e0b\u8f7d\uff0crequestId:{}", (Object)requestId);
        PushRecord pushRecord = this.pushRecordService.getByRequestId(requestId);
        if (pushRecord == null || StringUtils.isBlank((CharSequence)pushRecord.getExecuteErrorTxtPath()) || !FileUtil.exist((String)pushRecord.getExecuteErrorTxtPath())) {
            response.setContentType("text/html; charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.flush();
            out.println("<script defer='defer' type='text/javascript'>");
            out.println("alert('\u65e0\u9519\u8bef\u8bb0\u5f55txt\u4e0b\u8f7d');");
            out.println("</script>");
            return;
        }
        FileUtils.responseWithFile((String)pushRecord.getExecuteErrorTxtPath(), (HttpServletResponse)response);
    }

    @PostMapping(value={"/query/result/{requestId}"})
    public FerryReceiveTaskPushResult queryResult(@PathVariable(value="requestId") String requestId) {
        return this.pushDataService.queryBjFerryPushResult(requestId);
    }
}

