package com.bcxin.ferry.strategy.callback.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.dtos.FerryFileCallbackDto;
import com.bcxin.ferry.service.FerryTaskFileService;
import com.bcxin.ferry.service.FerryTaskService;
import com.bcxin.ferry.strategy.callback.ReceiveCallbackStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * description：接收任务文件回调策略
 * author：linchunpeng
 * date：2024/3/6
 */
@Slf4j
@Service
public class ReceiveTaskFileCallbackStrategy implements ReceiveCallbackStrategy {

    @Autowired
    private FerryTaskService ferryTaskService;
    @Autowired
    private FerryTaskFileService ferryTaskFileService;

    @Async
    @Override
    public void handle(String data) {
        //修改任务文件状态、摆渡任务状态
        Long taskId = ferryTaskService.updateFerryTaskFileResult(JSONObject.parseObject(data, FerryFileCallbackDto.class));
        if (taskId != null) {
            //开始摆渡明细文件
            ferryTaskService.sendFerryDetailFile(taskId);
            ferryTaskFileService.ferryDetailFile(taskId);
        }
    }
}
