package com.bcxin.ferry.strategy.callback;

import com.bcxin.ferry.common.CommonConstant;
import com.bcxin.ferry.common.utils.SpringContextUtils;

/**
 * 接收回调策略工厂
 */
public class ReceiveCallbackStrategyFactory {

    /**
     * 根据key，获取策略接口实现类
     */
    public static ReceiveCallbackStrategy getInstance(String key) {
        switch (key) {
            case CommonConstant.RECEIVE_CALLBACK_STRATEGY_KEY_TASK_FILE:
                //接收任务信息文件回调
                return SpringContextUtils.getBean("receiveTaskFileCallbackStrategy", ReceiveCallbackStrategy.class);
            case CommonConstant.RECEIVE_CALLBACK_STRATEGY_KEY_DETAIL_FILE:
                //接收任务明细文件回调
                return SpringContextUtils.getBean("receiveDetailFileCallbackStrategy", ReceiveCallbackStrategy.class);
            case CommonConstant.RECEIVE_CALLBACK_STRATEGY_KEY_FERRY_COMPLETE:
                //接收摆渡完成回调
                return SpringContextUtils.getBean("receiveFerryCompleteCallbackStrategy", ReceiveCallbackStrategy.class);
        }
        throw new RuntimeException(String.format("接收回调策略工厂：获取策略异常，key：%s", key));
    }

}
