package com.bcxin.ferry.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;

 /**
 * 摆渡任务表;
 * @author : linchunpeng
 * @date : 2024-3-6
 */
@Data
@TableName("ferry_task")
public class FerryTaskEntity implements Serializable {

private static final long serialVersionUID = 1L;
    
    //主键id
    @TableId(value = "id")
    private Long id;
    
    //请求id
    private String requestId;
    
    //区域代码
    private String regionCode;
    
    //拉取开始时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date startTime;
    
    //拉取结束时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date endTime;
    
    //摆渡包文件目录url
    private String packageUrl;
    
    //拉取结果
    private String pullResult;
    
    //文件总数
    private Integer fileTotalCount;
    
    //文件已摆渡总数
    private Integer fileFerryCount;
    
    //任务状态，1-开始拉取，2-拉取完成，3-扫描摆渡文件完成，4-生成任务文件完成，5-摆渡任务文件开始，6-摆渡任务文件完成，7-摆渡明细文件开始，8摆渡明细文件结束，9-摆渡任务完成，10-摆渡失败
    private Integer taskStatus;
    
    //摆渡结果
    private String ferryResult;
    
    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;
    
    //更新时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}