package com.bcxin.ferry.strategy.receive.impl;

import com.bcxin.ferry.common.queue.DetailFileQueue;
import com.bcxin.ferry.strategy.receive.ReceiveStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * description：接收明细文件策略
 * author：linchunpeng
 * date：2024/3/6
 */
@Slf4j
@Service
public class ReceiveDetailFileStrategy implements ReceiveStrategy {

    @Async(value = "taskExecutor")
    @Override
    public void handle(String data) {
        try {
            log.info("接收明细文件策略，参数放入队列");
            DetailFileQueue.DETAIL_FILE_RECEIVE_QUEUE.put(data);
            log.info("接收明细文件策略，参数放入队列，完成");
        } catch (InterruptedException e) {
            e.printStackTrace();
            log.error("接收明细文件策略，参数放入队列异常，{}", e.getMessage(), e);
        }
    }
}
