package com.bcxin.ferry.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;

 /**
 * 摆渡请求日志表;
 * @author : linchunpeng
 * @date : 2024-3-6
 */
@Data
@TableName("ferry_request_log")
public class FerryRequestLogEntity implements Serializable {

private static final long serialVersionUID = 1L;
    
    //主键id(文件id)
    @TableId(value = "id")
    private Long id;
    
    //摆渡任务id
    private Long taskId;
    
    //摆渡文件id
    private Long fileId;
    
    //请求接口url
    private String apiUrl;
    
    //请求参数（不含文件）
    private String requestParam;
    
    //请求结果
    private String requestResult;
    
    //接口返回时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date apiReturnTime;
    
    //边界服务任务id
    private String boundaryTaskId;
    
    //摆渡状态，1-发送请求，2-返回边界任务id，3-摆渡成功
    private Integer ferryStatus;
    
    //摆渡成功时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date successTime;
    
    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;
    
    //更新时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}