package com.bcxin.ferry.configs;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * description：摆渡工具服务配置
 * author：linchunpeng
 * date：2024/3/8
 */
@Data
@Component
@ConfigurationProperties(prefix = "baiduutil-server-config")
public class BaiduutilServerConfig {

    //目标系统配置
    private String regionCodes;
    //接口配置
    private Api api;
    //政务的摆渡工具接口配置
    private Api govoutApi;

    @Data
    public static class Api {
        //拉取数据包接口
        private String pullUrl;
        //推送数据包接口
        private String pushUrl;
        //查询拉取结果接口
        private String pullQueryResultUrl;
        //下载拉取结果包接口
        private String pullDownloadResultUrl;
        //查询推送结果接口
        private String pushQueryResultUrl;
        //上传摆渡包接口
        private String pushUploadUrl;
    }

    public Api getRequestApi(boolean isZw) {
        if (isZw) {
            return govoutApi;
        }
        return api;
    }
}
