/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.bcx.infrastructures.enums.ExamReferenceType;
import com.bcxin.tenant.bcx.infrastructures.enums.MetaCreatorReferenceType;
import java.sql.Timestamp;
import java.time.Instant;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

@TableName(value="bus_exam_enrollment_criteria", autoResultMap=true)
public class ExamEnrollmentCriteriaEntity
extends EntityAbstract
implements Aggregate {
    @TableId(value="id")
    private String id;
    @TableField(value="subject_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private ExamReferenceType subjectType;
    @TableField(value="subject_number")
    private String subjectNumber;
    @TableField(value="reference_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private MetaCreatorReferenceType referenceType;
    @TableField(value="reference_number")
    private String referenceNumber;
    @TableField(value="name")
    private String name;
    @TableField(value="note")
    private String note;
    @TableField(value="created_time")
    private Timestamp createdTime;
    @TableField(value="last_updated_time")
    private Timestamp lastUpdatedTime;
    @TableField(value="creator_id")
    private String creatorId;
    @TableField(value="creator_name")
    private String creatorName;
    @TableField(value="last_updater_id")
    private String lastUpdaterId;
    @TableField(value="last_updater_name")
    private String lastUpdaterName;
    @TableField(value="deleted")
    private boolean deleted;

    public ExamEnrollmentCriteriaEntity() {
        this.setDeleted(false);
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static ExamEnrollmentCriteriaEntity create(String id, ExamReferenceType subjectType, String subjectNumber, TenantEmployeeContext.TenantUserModel creator) {
        ExamEnrollmentCriteriaEntity entity = new ExamEnrollmentCriteriaEntity();
        entity.setId(id);
        entity.setSubjectType(subjectType);
        entity.setSubjectNumber(subjectNumber);
        entity.setReferenceType(creator.getUserType());
        entity.setReferenceNumber(creator.getOrganizationId());
        entity.setCreatorId(creator.getName());
        return entity;
    }

    public void change(String name, String note, TenantEmployeeContext.TenantUserModel lastUpdater) {
        this.setName(name);
        this.setNote(note);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastUpdaterId(lastUpdater.getId());
        this.setLastUpdaterName(lastUpdater.getName());
    }

    public String getId() {
        return this.id;
    }

    public ExamReferenceType getSubjectType() {
        return this.subjectType;
    }

    public String getSubjectNumber() {
        return this.subjectNumber;
    }

    public MetaCreatorReferenceType getReferenceType() {
        return this.referenceType;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getNote() {
        return this.note;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public String getLastUpdaterId() {
        return this.lastUpdaterId;
    }

    public String getLastUpdaterName() {
        return this.lastUpdaterName;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSubjectType(ExamReferenceType subjectType) {
        this.subjectType = subjectType;
    }

    public void setSubjectNumber(String subjectNumber) {
        this.subjectNumber = subjectNumber;
    }

    public void setReferenceType(MetaCreatorReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setLastUpdaterId(String lastUpdaterId) {
        this.lastUpdaterId = lastUpdaterId;
    }

    public void setLastUpdaterName(String lastUpdaterName) {
        this.lastUpdaterName = lastUpdaterName;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String toString() {
        return "ExamEnrollmentCriteriaEntity(id=" + this.getId() + ", subjectType=" + this.getSubjectType() + ", subjectNumber=" + this.getSubjectNumber() + ", referenceType=" + this.getReferenceType() + ", referenceNumber=" + this.getReferenceNumber() + ", name=" + this.getName() + ", note=" + this.getNote() + ", createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", creatorId=" + this.getCreatorId() + ", creatorName=" + this.getCreatorName() + ", lastUpdaterId=" + this.getLastUpdaterId() + ", lastUpdaterName=" + this.getLastUpdaterName() + ", deleted=" + this.isDeleted() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExamEnrollmentCriteriaEntity)) {
            return false;
        }
        ExamEnrollmentCriteriaEntity other = (ExamEnrollmentCriteriaEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ExamReferenceType this$subjectType = this.getSubjectType();
        ExamReferenceType other$subjectType = other.getSubjectType();
        if (this$subjectType == null ? other$subjectType != null : !this$subjectType.equals(other$subjectType)) {
            return false;
        }
        String this$subjectNumber = this.getSubjectNumber();
        String other$subjectNumber = other.getSubjectNumber();
        if (this$subjectNumber == null ? other$subjectNumber != null : !this$subjectNumber.equals(other$subjectNumber)) {
            return false;
        }
        MetaCreatorReferenceType this$referenceType = this.getReferenceType();
        MetaCreatorReferenceType other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !this$referenceType.equals(other$referenceType)) {
            return false;
        }
        String this$referenceNumber = this.getReferenceNumber();
        String other$referenceNumber = other.getReferenceNumber();
        if (this$referenceNumber == null ? other$referenceNumber != null : !this$referenceNumber.equals(other$referenceNumber)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        if (this$note == null ? other$note != null : !this$note.equals(other$note)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Timestamp this$lastUpdatedTime = this.getLastUpdatedTime();
        Timestamp other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$creatorId = this.getCreatorId();
        String other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !this$creatorId.equals(other$creatorId)) {
            return false;
        }
        String this$creatorName = this.getCreatorName();
        String other$creatorName = other.getCreatorName();
        if (this$creatorName == null ? other$creatorName != null : !this$creatorName.equals(other$creatorName)) {
            return false;
        }
        String this$lastUpdaterId = this.getLastUpdaterId();
        String other$lastUpdaterId = other.getLastUpdaterId();
        if (this$lastUpdaterId == null ? other$lastUpdaterId != null : !this$lastUpdaterId.equals(other$lastUpdaterId)) {
            return false;
        }
        String this$lastUpdaterName = this.getLastUpdaterName();
        String other$lastUpdaterName = other.getLastUpdaterName();
        return !(this$lastUpdaterName == null ? other$lastUpdaterName != null : !this$lastUpdaterName.equals(other$lastUpdaterName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExamEnrollmentCriteriaEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ExamReferenceType $subjectType = this.getSubjectType();
        result = result * 59 + ($subjectType == null ? 43 : $subjectType.hashCode());
        String $subjectNumber = this.getSubjectNumber();
        result = result * 59 + ($subjectNumber == null ? 43 : $subjectNumber.hashCode());
        MetaCreatorReferenceType $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : $referenceType.hashCode());
        String $referenceNumber = this.getReferenceNumber();
        result = result * 59 + ($referenceNumber == null ? 43 : $referenceNumber.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Timestamp $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : $creatorId.hashCode());
        String $creatorName = this.getCreatorName();
        result = result * 59 + ($creatorName == null ? 43 : $creatorName.hashCode());
        String $lastUpdaterId = this.getLastUpdaterId();
        result = result * 59 + ($lastUpdaterId == null ? 43 : $lastUpdaterId.hashCode());
        String $lastUpdaterName = this.getLastUpdaterName();
        result = result * 59 + ($lastUpdaterName == null ? 43 : $lastUpdaterName.hashCode());
        return result;
    }
}

