package com.bcxin.tenant.bcx.jdks.responses.metas;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import lombok.Data;

import java.sql.Timestamp;

/**
 * 菜单元数据响应
 */
@Data
public class MenuMetaResponse extends ResponseAbstract {
    private String id;
    private String name;
    private String projectId;
    private String pageId;
    private String parentId;
    private String indexTreeId;
    private String slug;
    private int mediumType;
    private Timestamp createdTime;
    private Timestamp lastUpdatedTime;

    public MenuMetaResponse(String id, String name, String projectId, String pageId, String parentId, String indexTreeId, String slug, int mediumType, Timestamp createdTime, Timestamp lastUpdatedTime) {
        this.id = id;
        this.name = name;
        this.projectId = projectId;
        this.pageId = pageId;
        this.parentId = parentId;
        this.indexTreeId = indexTreeId;
        this.slug = slug;
        this.mediumType = mediumType;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public static MenuMetaResponse from(String id, String name, String projectId, String pageId,
                                       String parentId, String indexTreeId, String slug, int mediumType,
                                       Timestamp createdTime, Timestamp lastUpdatedTime) {
        return new MenuMetaResponse(id, name, projectId, pageId, parentId, indexTreeId, slug, mediumType, createdTime, lastUpdatedTime);
    }
}
