package com.bcxin.tenant.bcx.jdks.responses.examSubjects;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import lombok.Getter;

@Getter
public class ExamSubjectResponse extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String institutionalTypeCode;
    private final String industryTypeCode;
    private final String regionCode;

    public ExamSubjectResponse(String id, String name, String institutionalTypeCode, String industryTypeCode, String regionCode) {
        this.id = id;
        this.name = name;
        this.institutionalTypeCode = institutionalTypeCode;
        this.industryTypeCode = industryTypeCode;
        this.regionCode = regionCode;
    }

    public static ExamSubjectResponse create(String id, String name, String institutionalTypeCode, String industryTypeCode, String regionCode) {
        return new ExamSubjectResponse(id, name, institutionalTypeCode, industryTypeCode, regionCode);
    }
}
