package com.bcxin.tenant.bcx.jdks.requests.metas;

import com.bcxin.tenant.bcx.jdks.requests.SearchRequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 模块搜索请求
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ModuleMetaSearchRequest extends SearchRequestAbstract {
    @Schema(name = "id", title = "主键", requiredMode = Schema.RequiredMode.NOT_REQUIRED, hidden = true )
    private String id;

    @Schema(name = "ids", title = "主键列表", requiredMode = Schema.RequiredMode.NOT_REQUIRED, hidden = true )
    private List<String> ids;

    @Schema(name = "projectId", title = "项目ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String projectId;

    @Schema(name = "name", title = "模块名称", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String name;
}
