package com.bcxin.tenant.bcx.infrastructures.configs;

import com.bcxin.tenant.bcx.infrastructures.utils.StringUtil;
import lombok.AccessLevel;
import lombok.Getter;

@Getter(AccessLevel.PRIVATE)
public class TenantSystemConfig {
    private final String regionCode;

    public TenantSystemConfig(String regionCode) {
        this.regionCode = regionCode;
    }

    /**
     * 这个必须是数字; 返回1为数字
     * 互联网为: 0
     * 山西晋城为: 5
     * @return
     */
    public  String getPrefixRoomNo() {
        if (!StringUtil.isEmpty(this.getRegionCode()) && this.getRegionCode().startsWith("1405")) {
            return "5";
        }

        return "0";
    }
}
