package com.bcxin.tenant.flink.job.definitions;

import com.bcxin.tenant.open.infrastructures.flinks.FlinkDefinitionAbstract;
import lombok.Data;

import java.util.Collection;

@Data
public class KafkaMetaDefinition extends FlinkDefinitionAbstract {
    private String autoOffsetRest = "earliest";
    private String scanStartupMode = "earliest-offset";//""group-offsets";
    private String enableAutoCommit = "true";
    private String bootstrapServer;
    private Collection<KafkaMetaTopicDefinition> topicDefinitions;

    @Data
    public static class KafkaMetaTopicDefinition extends FlinkDefinitionAbstract {
        private String topic;
        private String sql;

        public String getFullDefinitionSql(KafkaMetaDefinition definition) {
            return String.format("%s WITH ('connector'='kafka','scan.startup.mode'='%s','properties.group.id'='%s-consumer','topic' = '%s',"+
                    "'properties.bootstrap.servers' = '%s','format'='debezium-json')",
                    this.getSql(),
                    definition.getScanStartupMode(),this.getTopic(), this.getTopic(), definition.getBootstrapServer());
        }
    }
}