package com.bcxin.flink.core.utils;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.commons.lang3.StringUtils;

import java.util.Iterator;

public class JsonNodeUtils {
    public static JsonNode getSubJsonNodeByName(JsonNode jsonNode, String fieldName) {
        if (StringUtils.isEmpty(fieldName)) {
            return null;
        }

        JsonNode selectedNode = jsonNode.get(fieldName);

        if (selectedNode == null) {
            Iterator<String> iterator = jsonNode.fieldNames();
            while (iterator.hasNext()) {
                String f = iterator.next();
                if (fieldName.equalsIgnoreCase(f)) {
                    return jsonNode.get(f);
                }
            }
        }

        return selectedNode;
    }
}
