package com.bcxin.flink.core.properties;

import com.bcxin.flink.core.properties.impls.DiskCheckpointConfigPropertyImpl;
import com.bcxin.flink.core.properties.impls.HdfsCheckpointConfigPropertyImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;

import java.io.IOException;
import java.util.Properties;

public class CheckpointConfigPropertyBuilder {
    public static CheckpointConfigProperty build(Properties properties) throws IOException {
        CheckpointConfigProperty configProperty = null;
        String mode = properties.getProperty(StreamingConfigConstants.CHECKPOINT_MODE);
        switch (mode) {
            case StreamingConfigConstants.CHECKPOINT_MODE_VALUE_FILE:
                configProperty = DiskCheckpointConfigPropertyImpl.create(
                        properties.getProperty(StreamingConfigConstants.DISK_CHECKPOINT_LOCATION)
                );
                break;
            case StreamingConfigConstants.CHECKPOINT_MODE_VALUE_HDFS:
                String coreSiteConfig = properties.getProperty(StreamingConfigConstants.HDFS_CONF);
                Configuration.addDefaultResource(coreSiteConfig);
                Configuration conf = new Configuration();
                if (!StringUtils.isEmpty(properties.getProperty(StreamingConfigConstants.HDFS_DEFAULT_FS))) {
                    conf.set(StreamingConfigConstants.HDFS_DEFAULT_FS, properties.getProperty(StreamingConfigConstants.HDFS_DEFAULT_FS));
                }
                if (!StringUtils.isEmpty(properties.getProperty(StreamingConfigConstants.HDFS_CHECKPOINT_CONTEXT_PATH))) {
                    conf.set(StreamingConfigConstants.HDFS_CHECKPOINT_CONTEXT_PATH, properties.getProperty(StreamingConfigConstants.HDFS_CHECKPOINT_CONTEXT_PATH));
                }
                if (!StringUtils.isEmpty(properties.getProperty(StreamingConfigConstants.HDFS_IPC_MAXIMUM_DATA_LENGTH))) {
                    conf.set(StreamingConfigConstants.HDFS_IPC_MAXIMUM_DATA_LENGTH, properties.getProperty(StreamingConfigConstants.HDFS_IPC_MAXIMUM_DATA_LENGTH));
                }
                if (!StringUtils.isEmpty(properties.getProperty(StreamingConfigConstants.HDFS_IPC_MAXIMUM_RESPONSE_LENGTH))) {
                    conf.set(StreamingConfigConstants.HDFS_IPC_MAXIMUM_RESPONSE_LENGTH,
                            properties.getProperty(StreamingConfigConstants.HDFS_IPC_MAXIMUM_RESPONSE_LENGTH));
                }

                configProperty = HdfsCheckpointConfigPropertyImpl.create(
                        conf,
                        conf.get(StreamingConfigConstants.HDFS_DEFAULT_FS),
                        conf.get(StreamingConfigConstants.HDFS_CHECKPOINT_CONTEXT_PATH)
                );
                break;
        }

        return configProperty;
    }
}
