package com.bcxin.flink.core;

import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SystemPropertyUtil {
    public static Properties loadEnvConf(String env) throws IOException {
        Properties properties = System.getProperties();

        ClassLoader classLoader = SystemPropertyUtil.class.getClassLoader();
        try (InputStream coreStream = classLoader.getResourceAsStream(
                String.format("jdbcs/task-%s.properties", env))) {
            if (coreStream == null) {
                throw new BadTenantException(String.format("找不到该环境配置:%s", env));
            }

            properties.load(coreStream);
        }

        return properties;
    }
}
