package com.bcxin.flink.core;

import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingCoreEnvironments {
    private final static Logger logger = LoggerFactory.getLogger(StreamingCoreEnvironments.class);
    /**
     *
     * 获取基本的配置以及上次的savepoint点
     * https://cloud.tencent.com/developer/article/2010848
     * 销售，
     *  这边使用hdfs的一个问题是, 会导致datanode的节点挂掉问题
     * @return
     */
    public static StreamExecutionEnvironment getStreamExecutionEnvironment(CoreJobContext jobContext) {
        logger.info("开始获取getStreamExecutionEnvironment对象:SavepointPath={};CheckpointPath={}",
                jobContext.getConfigProperty().getSavepointPath(),
                jobContext.getConfigProperty().getCheckpointPath());
        if (false) {
            Configuration configuration = new Configuration();

            if (!StringUtils.isEmpty(jobContext.getConfigProperty().getSavepointPath())) {
                configuration.setString("execution.savepoint.path", jobContext.getConfigProperty().getSavepointPath());
            }
            //configuration.setString("execution.savepoint.path", "file:///E:/bcxin/flink/check-02/0b91accd899fd8e71392ffa7d0c4cdaf/chk-169");

            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment(configuration);
            env.enableCheckpointing(5000, CheckpointingMode.EXACTLY_ONCE);

            CheckpointConfig checkpointConfig = env.getCheckpointConfig();

            checkpointConfig.setCheckpointStorage(jobContext.getConfigProperty().getCheckpointPath());
            checkpointConfig.setCheckpointingMode(CheckpointingMode.EXACTLY_ONCE);
            checkpointConfig.setMaxConcurrentCheckpoints(2);
            return env;
        }

        return StreamExecutionEnvironment.getExecutionEnvironment();
    }

    /*
        //设置后端状态
    private static void setStateBackend(StreamExecutionEnvironment env,
                                        CheckPointParam checkPointParam) throws IOException {
        switch (checkPointParam.getStateBackendEnum()) {
            case MEMORY:
                log.info("开启MEMORY模式");
                env.setStateBackend(
                        new MemoryStateBackend(MemoryStateBackend.DEFAULT_MAX_STATE_SIZE * 100));
                break;
            case FILE:
                log.info("开启FILE模式");
                if (checkPointParam.getAsynchronousSnapshots() != null) {
                    env.setStateBackend(new FsStateBackend(checkPointParam.getCheckpointDir(),
                            checkPointParam.getAsynchronousSnapshots()));
                } else {
                    env.setStateBackend(new FsStateBackend(checkPointParam.getCheckpointDir()));
                }
                break;
            case ROCKSDB:
                log.info("开启ROCKSDB模式");
                if (checkPointParam.getEnableIncremental() != null) {
                    env.setStateBackend(new RocksDBStateBackend(checkPointParam.getCheckpointDir(),
                            checkPointParam.getEnableIncremental()));
                } else {
                    env.setStateBackend(new RocksDBStateBackend(checkPointParam.getCheckpointDir()));
                }
                break;
            default:
                throw new RuntimeException("不支持这种后端状态" + checkPointParam.getStateBackendEnum());

        }

     */
}
