/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.jdks.requests.UpdateGeoRequest;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class SyncUpdateGeoRequest
extends UpdateGeoRequest {
    private Collection<String> employeeIds;
    private Timestamp timestamp = Timestamp.from(Instant.now());

    public static SyncUpdateGeoRequest create(UpdateGeoRequest request, Collection<String> employeeIds) {
        SyncUpdateGeoRequest syncUpdateGeoRequest = new SyncUpdateGeoRequest();
        if (!CollectionUtils.isEmpty(employeeIds)) {
            syncUpdateGeoRequest.setEmployeeIds(employeeIds.stream().filter(ii -> !StringUtil.isEmpty((String)ii)).collect(Collectors.toList()));
        } else {
            syncUpdateGeoRequest.setEmployeeIds(employeeIds);
        }
        syncUpdateGeoRequest.setAddress(request.getAddress());
        syncUpdateGeoRequest.setLatitude(request.getLatitude());
        syncUpdateGeoRequest.setLongitude(request.getLongitude());
        return syncUpdateGeoRequest;
    }

    @Override
    public Collection<String> getEmployeeIds() {
        return this.employeeIds;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setEmployeeIds(Collection<String> employeeIds) {
        this.employeeIds = employeeIds;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SyncUpdateGeoRequest)) {
            return false;
        }
        SyncUpdateGeoRequest other = (SyncUpdateGeoRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<String> this$employeeIds = this.getEmployeeIds();
        Collection<String> other$employeeIds = other.getEmployeeIds();
        if (this$employeeIds == null ? other$employeeIds != null : !((Object)this$employeeIds).equals(other$employeeIds)) {
            return false;
        }
        Timestamp this$timestamp = this.getTimestamp();
        Timestamp other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SyncUpdateGeoRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<String> $employeeIds = this.getEmployeeIds();
        result = result * 59 + ($employeeIds == null ? 43 : ((Object)$employeeIds).hashCode());
        Timestamp $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SyncUpdateGeoRequest(employeeIds=" + this.getEmployeeIds() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

