/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.flink.job.jobs;

import com.bcxin.flink.core.CoreJobContext;
import com.bcxin.flink.core.StreamingCoreEnvironments;
import com.bcxin.tenant.flink.job.StreamingJobContext;
import com.bcxin.tenant.flink.job.definitions.JobDataDefinition;
import com.bcxin.tenant.flink.job.definitions.KafkaMetaDefinition;
import com.bcxin.tenant.flink.job.functions.Convert2PointFunction;
import com.bcxin.tenant.open.infrastructures.flinks.FlinkJobAbstract;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamStatementSet;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.functions.UserDefinedFunction;

public class ScriptDispatchJob
extends FlinkJobAbstract {
    private final JobDataDefinition definition;

    public ScriptDispatchJob(JobDataDefinition definition) {
        this.definition = definition;
    }

    protected void coreExecute() throws Exception {
        StreamingJobContext jobContext = StreamingJobContext.getInstance();
        StreamExecutionEnvironment env = StreamingCoreEnvironments.getStreamExecutionEnvironment((CoreJobContext)jobContext);
        env.setParallelism(5);
        StreamTableEnvironment tableEnvironment = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        tableEnvironment.createTemporaryFunction("convert2Point", (UserDefinedFunction)new Convert2PointFunction());
        KafkaMetaDefinition kafkaMetaDefinition = this.definition.getKafkaMeta();
        if (kafkaMetaDefinition != null && !CollectionUtils.isEmpty(kafkaMetaDefinition.getTopicDefinitions())) {
            kafkaMetaDefinition.getTopicDefinitions().forEach(td -> tableEnvironment.executeSql(td.getFullDefinitionSql(kafkaMetaDefinition)));
        }
        if (this.definition.getJdbcMeta() != null && !CollectionUtils.isEmpty(this.definition.getJdbcMeta().getSqlMetaDefinitions())) {
            this.definition.getJdbcMeta().getSqlMetaDefinitions().forEach(sl -> {
                String fullSql = sl.getFullSql(this.definition.getJdbcMeta());
                tableEnvironment.executeSql(fullSql);
            });
        }
        StreamStatementSet statementSet = tableEnvironment.createStatementSet();
        this.definition.getExecuteSql().forEach(ix -> statementSet.addInsertSql(ix));
        TableResult result = statementSet.execute();
        result.print();
    }
}

