import axios, { AxiosInstance, AxiosRequestConfig } from 'axios';
// import qs from 'qs';
import { ElMessage, ElMessageBox } from 'element-plus';
import { Session } from './storage';

// 配置新建一个 axios 实例
const service: AxiosInstance = axios.create({
  baseURL: import.meta.env.VITE_API_URL,
  timeout: 50000,
  headers: {
    'Content-Type': 'application/json',
  },
  // paramsSerializer: {
  //   serialize(params) {
  //     // debugger
  //     return qs.stringify(params, { allowDots: true });
  //   }
  // }
});

// 添加请求拦截器
service.interceptors.request.use(
	(config: AxiosRequestConfig | any) => {
		// 在发送请求之前做些什么 token	
		let accessToken = localStorage.getItem('accessToken') || 'eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsImV4cCI6MTY5MTkxMTczNiwidXNlcm5hbWUiOiIwMDN6N3VYdjEifQ.6Vo_rSc1JnM9uv9ebydAzCv4pStRyINmi1ttcAvJjTI';
		let dispatchToken = localStorage.getItem('dispatchToken') || '';
		// console.log('dispatchToken', dispatchToken)
		if (Session.get('token')) {
			config.headers!['Authorization'] = `${Session.get('token')}` || 'eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsImV4cCI6MTY5MTkxMTczNiwidXNlcm5hbWUiOiJfX0E3eVZ2ajMzUlJIc09MZ3Z0MGQifQ.4WcOegxFXDwaaKXwIiNbKrcUJOIW95wI1BwU8MSqeMI';
			config.headers!['accessToken'] = accessToken;
			config.headers!['dispatchToken'] = dispatchToken || 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsImV4cCI6MTY4MDkyMzAzOSwidXNlcm5hbWUiOiJ7XCJlaWRcIjpcIjAwM3o3dVh2XCIsXCJpZFwiOlwibkFicXVhM2lcIixcImlzRGVza1wiOnRydWUsXCJuYW1lXCI6XCLmtYvor5Xlj7cwNlwiLFwib2NUeXBlXCI6XCJOb3JtYWxcIixcIm9ySWRcIjpcIlJUYXJYQ01zXCJ9In0._TXV0xixfx1cL1Kla0556BwihnDTrFV1BbJvbQQJuRU';
      // config.headers!['bcxToken'] = `${Session.get('token')}` || 'eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsImV4cCI6MTY5MTkxMTczNiwidXNlcm5hbWUiOiJfX0E3eVZ2ajMzUlJIc09MZ3Z0MGQifQ.4WcOegxFXDwaaKXwIiNbKrcUJOIW95wI1BwU8MSqeMI';
			// config.headers!['accountType'] = 'Desk';//"accountType":"APP",//防控指挥账号类型：百保盾APP，第三方设备Device，调度台客户端Desk
      config.headers!['Authori-Zation']	= localStorage.getItem('shop_token');
		}
    config.headers!['Authori-Zation']	= localStorage.getItem('shop_token');
		return config;
	},
	(error) => {
		// 对请求错误做些什么
		return Promise.reject(error);
	}
);

// 添加响应拦截器
service.interceptors.response.use(
	(response) => {
		// 对响应数据做点什么
		// console.log('response', response)
		const res = response.data;
		if (res.code && res.code !== 0) {
			// `token` 过期或者账号已在别处登录
			if (res.code === 401 || res.code === 4001) {
				Session.clear(); // 清除浏览器全部临时缓存
				// window.location.href = '/'; // 去登录页
				ElMessageBox.alert('你已被登出，请重新登录', '提示', {})
					.then(() => { 
            // window.location.href = 'https://v5qy.te.baibaodun.com.cn/static/signon/';
            window.location.href = 'https://v5qy.baibaodun.cn/static/signon/'
          })
					.catch(() => { });
			}
			
      return Promise.resolve(response.data)
		} else {
      return Promise.reject(service.interceptors.response);
		}
	},
	(error) => {
		if (error && (error.response) && (error.response.status)) {//405表示 not allowed
			ElMessage.error(error.response.data.msg)
			return Promise.resolve(error.response.data)
		}
		// 对响应错误做点什么
		if (error.message.indexOf('timeout') != -1) {
			ElMessage.error('网络超时');
		} else if (error.message == 'Network Error') {
			ElMessage.error('网络连接错误');
		} else {
			if (error.response && error.response.data) ElMessage.error(error.response.statusText);
			else ElMessage.error('接口路径找不到');
		}
		return Promise.reject(error);
	}
);

// 导出 axios 实例
export default service;