import request from '../utils/request';

/**
 * @description
 * 获取发票列表
 */
export const getInvoiceListApi = (params: Record<any, any>):Promise<any> => {
  return request({
    url: `api/front/order/fapiao/list`,
    method: 'GET',
    params
  });
}

/**
 * @description
 * 获取发票抬头列表
 */
export const getInvoiceHeaderListApi = (params: Record<any, any>):Promise<any> => {
  return request({
    url: `api/front/fapiao/title/list`,
    method: 'GET',
    params
  });
}

/**
 * @description
 * 新增和编辑发票抬头
 */
export const addInvoiceHeaderApi = (data: Record<any, any>, type: string):Promise<any> => {
  let url = type === 'edit' ? `api/front/fapiao/title/update` : `api/front/fapiao/title/create`;

  return request({
    url,
    method: 'POST',
    data,
  });
}

/**
 * @description
 * 删除发票抬头
 */
export const delInvoiceHeaderApi = (data: Record<any, any>):Promise<any> => {
  return request({
    url: `api/front/fapiao/title/delete/${data.id}`,
    method: 'POST',
    data,
  });
}

/**
 * @description
 * 新增订单发票
 */
export const createInvoiceApi = (data: Record<any, any>):Promise<any> => {
  return request({
    url: `api/front/order/fapiao/create`,
    method: 'POST',
    data,
  });
}

/**
 * @description
 * 查询发票订单详情
 */
export const getInvoiceDetailApi = (data: Record<any, any>):Promise<any> => {
  return request({
    url: `api/front/order/fapiao/info/${data.id}`,
    method: 'GET',
    data,
  });
}


