package com.bcxin.backend.domain.system.dispatch.snapshots;

public class ValueRemovedSnapshot extends ValueSnapshot {
    private final String[] ids;

    private ValueRemovedSnapshot(String[] ids) {
        this.ids = ids;
    }

    public String[] getIds() {
        return ids;
    }

    public String getConnectedIds() {
        return String.join(",", getIds());
    }

    public static ValueRemovedSnapshot create(String... ids) {
        return new ValueRemovedSnapshot(ids);
    }

    @Override
    protected PriorityValue getPriority() {
        return PriorityValue.Normal;
    }
}
