package com.bcxin.backend.domain.system.dispatch.snapshots;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter(AccessLevel.PROTECTED)
public class DomainValueSnapshot extends ValueSnapshot {

    private String id;

    private String name;

    /**
     * 组织统一社会信用代码
     */
    private String organizeCode;

    /**
     * 统一社会信用代码证扫描件
     */
    private String certificate;

    /**
     * 注册地址
     */
    private String registeredAddress;

    /**
     * 经营地址
     */
    private String organizedAddress;

    private DomainValueSnapshot() {
    }

    public static DomainValueSnapshot create(String id, String name,
                                             String organizeCode,
                                             String certificate,
                                             String registeredAddress,
                                             String organizedAddress) {
        DomainValueSnapshot valueSnapshot = new DomainValueSnapshot();
        valueSnapshot.setId(id);
        valueSnapshot.setName(name);
        valueSnapshot.setOrganizeCode(organizeCode);
        valueSnapshot.setCertificate(certificate);
        valueSnapshot.setOrganizedAddress(organizedAddress);
        valueSnapshot.setRegisteredAddress(registeredAddress);

        return valueSnapshot;
    }

    @Override
    protected PriorityValue getPriority() {
        return PriorityValue.Domain;
    }
}
