package com.bcxin.risk.user.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 专家类型配置
 *
 * @author 张建华
 */
@Entity
@Table(name = "risk_expert_type")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ExpertType extends BaseBean {

    private static final long serialVersionUID = 1L;

    /**
     * 专家类型
     */
    private String expertType;

    /**
     * 专家类型名称
     */
    private String expertName;


}
