package com.bcxin.risk.surveytk.enums;

/**
 * @author hzp
 * 踏勘任务状态
 */
public enum TaskStatusEnum {

    UN_DISTRI("100","待分配"),
    UN_ACCEPT("101","未接受"),
    ACCEPT("102","已接受"),
    REFUSE("103","已拒绝"),
    FINISH("104","已完成"),
    CLOSE("105","结束"),
    EXPIRE("106","已过期");

    private String key;
    private String alias;

    TaskStatusEnum(String key,String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(TaskStatusEnum e : TaskStatusEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
