package com.bcxin.risk.survey.domain;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.user.domain.ExpertUser;
import com.bcxin.risk.user.domain.User;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

/**
 * 任务
 * 
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_TASK")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = Task.class)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Task extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 活动
	 */
	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;

	private String name;

	@ManyToOne(targetEntity = User.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "assgin_id")
	private User assgin;

	@ManyToOne(targetEntity = ExpertUser.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "consultation_id")
	private ExpertUser consultation;

	@Column(name="assgin_id", updatable=false, insertable=false)
	private Long assginId;//用户id
	/**
	 * 踏勘专家
	 */
//	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "expert_id")
	private String expert_id;

	private String acceptStatus; //任务接收状态
	
	private String taskStatus; //任务处理状态

	private String taskType;

	@Temporal(TemporalType.TIMESTAMP)
	private Date acceptDate; //任务接收时间
	
	@Temporal(TemporalType.TIMESTAMP)
	private Date finishDate;
	
	private String period; //任务处理时间


	@Column(name = "tk_config")
	private String tkConfig;//踏勘阶级  (TK01,TK02,TK03)（产品类型：初阶踏勘、进阶踏勘、高阶踏勘）

	@Column(name = "zj_config")
	private String zjConfig;//专家类型 (ZJ01,ZJ02,ZJ03)（产品类型：现场专家、远程专家、咨询专家）


	public String getMaxTKConfig(String tkConfig){
		if(StringUtil.isEmpty(this.tkConfig)){
			return "";
		}
		if (tkConfig.equals(ProductCode.SURVEY_LEVEL_3)){
			return tkConfig;
		}else if (tkConfig.equals(ProductCode.SURVEY_LEVEL_2)&&this.tkConfig.equals(ProductCode.SURVEY_LEVEL_1)){
			return tkConfig;
		}else {
			return this.tkConfig;
		}
	}

	public int getTKConfigLeve() {
		if(StringUtil.isEmpty(this.tkConfig)){
			return 0;
		}
		if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_3)){
			return 3;
		}else if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_2)){
			return 2;
		}else if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_1)){
			return 1;
		}else{
			return 0;
		}
	}

	public boolean isSurveyTask(String productCode) {
		if(StringUtil.isEmpty(this.tkConfig)){
			return true;
		}
		if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_3)){
			return false;
		}else if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_2)&&!productCode.equals(ProductCode.SURVEY_LEVEL_3)){
			return false;
		}else if (this.tkConfig.equals(ProductCode.SURVEY_LEVEL_1)&&productCode.equals(ProductCode.SURVEY_LEVEL_1)){
			return false;
		}else {
			return true;
		}
	}

	public boolean isExpertType(String productCode) {
		if(StringUtil.isEmpty(this.zjConfig)){
			return true;
		}
		if (this.zjConfig.indexOf(productCode)>=0){
			return false;
		}else {
			return true;
		}
	}

	public Collection<String> getZJType() {
		//17 专家现场勘查，23 专家远程勘查 ，24 专家远程咨询
		// (ZJ01,ZJ02,ZJ03)（产品类型：现场专家、远程专家、咨询专家）
		Collection<String> zjType = new ArrayList<>();
		if(StringUtil.isNotEmpty(this.zjConfig)){
			if (this.zjConfig.indexOf(ProductCode.EXPERT_TYPE_3)>=0){
				zjType.add(ProductCode.T_K_TYPE_3);
			}
			if (this.zjConfig.indexOf(ProductCode.EXPERT_TYPE_2)>=0){
				zjType.add(ProductCode.T_K_TYPE_2);
			}
			if (this.zjConfig.indexOf(ProductCode.EXPERT_TYPE_1)>=0){
				zjType.add(ProductCode.T_K_TYPE_1);
			}
		}
		if(zjType.size()==0){
			return null;
		}
		return zjType;
	}
}
