package com.bcxin.risk.survey.domain;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;

/**
 * 查勘/整改现场照片
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Survey_Photo")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
public class Survey_Photo extends BaseBean {

	 
	private static final long serialVersionUID = 1L;
	
	/**  阿里ossKey*/
	private String ossKey;
	
	/**  图片路径*/
	private String path;
	
	/**  所属勘查问题*/
	@ManyToOne(targetEntity = Survey_Info.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "surveyInfoId")
	private Survey_Info surveyInfo;
	
	
	/** 所属整改 */
	@ManyToOne(targetEntity = SurveyReform.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "correctionId")
	private SurveyReform correction;


}
