package com.bcxin.risk.statistics.dto;

import java.util.Map;

public class StatisticsDto {

	private String reportTotal;
	
	private String peopleTotal;
	
	private String rejectTotal;
	
	private String duringTotal;
	
	private String todayTotal;

	private String addressTotal; 
	
	
	public StatisticsDto(){}
	
	public StatisticsDto(Map<String,Object> map){
		this.reportTotal = safeTransfor(map.get("reportTotal"));
		this.peopleTotal = safeTransfor(map.get("peopleTotal"));
		this.rejectTotal = safeTransfor(map.get("rejectTotal"));
		this.duringTotal = safeTransfor(map.get("duringTotal"));
		this.todayTotal = safeTransfor(map.get("reportTotal"));
		this.addressTotal = safeTransfor(map.get("addressTotal"));
	}
	
	
	/**
     * 
     * <b>Function 将Object安全转换为String</b> 
     * 
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}

	public String getReportTotal() {
		return reportTotal;
	}

	public void setReportTotal(String reportTotal) {
		this.reportTotal = reportTotal;
	}

	public String getPeopleTotal() {
		return peopleTotal;
	}

	public void setPeopleTotal(String peopleTotal) {
		this.peopleTotal = peopleTotal;
	}

	public String getRejectTotal() {
		return rejectTotal;
	}

	public void setRejectTotal(String rejectTotal) {
		this.rejectTotal = rejectTotal;
	}

	public String getDuringTotal() {
		return duringTotal;
	}

	public void setDuringTotal(String duringTotal) {
		this.duringTotal = duringTotal;
	}

	public String getTodayTotal() {
		return todayTotal;
	}

	public void setTodayTotal(String todayTotal) {
		this.todayTotal = todayTotal;
	}

	public String getAddressTotal() {
		return addressTotal;
	}

	public void setAddressTotal(String addressTotal) {
		this.addressTotal = addressTotal;
	}

}
