package com.bcxin.risk.report.enums;

public enum SurveyStep {

	FIRST {public String getValue(){return "1";} public String getName(){return "第1阶段勘查";}},

	SECOND {public String getValue(){return "2";} public String getName(){return "第2阶段勘查";}},
	
	THIRD {public String getValue(){return "3";} public String getName(){return "第3阶段勘查";}};
	

    public abstract String getValue();
    
    public abstract String getName();
    
    public static SurveyStep convertName(String name){
    	if ( "第1阶段".equals(name) ) {
    		return SurveyStep.FIRST;
    	} else if ("第2阶段".equals(name)) {
    		return SurveyStep.SECOND;
    	} else if ("第3阶段".equals(name)) {
    		return SurveyStep.THIRD;
    	}
    	return null;
    }
    
    public static SurveyStep convert(String value){
    	if ( "FIRST".equals(value) ) {
    		return SurveyStep.FIRST;
    	} else if ("SECOND".equals(value)) {
    		return SurveyStep.SECOND;
    	} else if ("THIRD".equals(value))
    		return SurveyStep.THIRD;
    	return null;
    }

	public static String convertAlias(String value){
		if ( "FIRST".equals(value) ) {
			return SurveyStep.FIRST.getName();
		} else if ("SECOND".equals(value)) {
			return SurveyStep.SECOND.getName();
		} else if ("THIRD".equals(value)) {
			return SurveyStep.THIRD.getName();
		}
		return null;
	}
    
    public static SurveyStep convertValue(String value){
     	 if("1".equals(value)){return SurveyStep.FIRST;}
	   	 else if("2".equals(value)){return SurveyStep.SECOND;}
	   	 else if("3".equals(value)){return SurveyStep.THIRD;}
	   	 else{return null;}
	}
    
}
