package com.bcxin.risk.policy.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 邮寄保单信息
 * 
 * @author king
 */
@Entity
@Table(name = "RISK_MailPolicy")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class MailPolicy extends BaseBean {

	private static final long serialVersionUID = 1L;

	private String invoiceTitle;// 发票的抬头
	
	//-----------------------------------------发票-------------------
	private String ticketName;//收票人姓名
	private String ticketPhone;//收票人电话
	private String ticketAddress;//收票人地址
	
	private String companyNameInvoice;
	private String taxpayerNumberInvoice;
	private String registerAddressInvoice;
	private String contactPhoneInvoice;
	private String bankInvoice;
	private String bankAccountInvoice;

	private String tax_cert;//税务登记证
	private String tax_cert_thumbnail;//缩略图

	private String tax_prove;// 一般纳税人证明
	private String tax_prove_thumbnail;//缩略图

	private String bank_licence;// 银行开户许可证
	private String bank_licence_thumbnail;//缩略图

	private String business_license;// 营业执照副本
	private String business_license_thumbnail;//缩略图

	private String auth_cert;// 增票授权委托书
	private String auth_cert_thumbnail;//缩略图
	
}
