package com.bcxin.risk.org.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 评估机构账户信息
 * @author hzp
 */
@Entity
@Table(name = "risk_org_account")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class OrgAccount extends BaseBean {

    /**银行卡号*/
    private String bankNo;

    /**开户行名称*/
    private String bankName;

    /**单位*/
    private String unitName;

    /**确认电话*/
    private String confirmTel;

    /**机构id*/
    private Long orgId;

}
