package com.bcxin.risk.org.domain;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.order.OrderForm;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

@Entity
@Table(name = "RISK_Invoice")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Invoice extends BaseBean {

    private static final long serialVersionUID = 1L;


    /**
     * 公司单位名称
     */
    private String companyName;
    /**
     * 发票的抬头
     */
    private String invoiceTitle;


    /**
     * 纳税人识别号
     */
    private String taxpayerNumber;


    /**
     * 公司注册地址
     */
    private String registerAddress;

    /**
     * 单位联系方式
     */
    private String contactPhone;

    /**
     * 开户银行
     */
    private String bank;

    /**
     * 发票类型
     */
    private String invoiceType;

    /**
     * 开户银行账号
     */
    private String bankAccount;

    /**
     * 一般纳税人证明
     */
    private String tax_prove;

    /**
     * 银行开户许可证
     */
    private String bank_licence;

    /**
     * 营业执照副本
     */
    private String business_license;

    /**
     * 税务登记证
     */
    private String tax_cert;

    /**
     * 增票授权委托书
     */
    private String auth_cert;

    /**
     * 收票人姓名
     */
    private String ticketName;

    /**
     * 收票人电话
     */
    private String ticketPhone;

    /**
     * 收票人邮箱
     */
    private String ticketEmail;
    /**
     * 收票人地址
     */
    private String ticketAddress;
    /**
     * 审核结果
     */
    private String approveActive;
    /**
     * 审核结果备注
     */
    private String remark;

    /**
     * 承办方机构
     */
    @OneToOne(targetEntity = Org.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "contractOrgId")
    private Org contractOrg;


    /**
     * 服务机构
     */
    @OneToOne(targetEntity = Org.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "orgId")
    private Org org;

    /**
     * 发票关联订单
     */
    @OneToOne(targetEntity = OrderForm.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "orderId")
    private OrderForm orderForm;

}
