package com.bcxin.risk.order.dto.search;


import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.user.domain.User;
import lombok.Data;

/**
 * 订单查询dto
 */
@Data
public class OrderFormSearchDTO {

	private Activity activity;

	private User user;

	private Org org;

	private String keyname;

	/**
	 * 订单状态
	 */
	private String orderStatus;

	/**
	 * 活动状态
	 */
	private String activityStatus;
	/**
	 * 活动来源
	 */
	private String activitySource;

	/**
	 * 下单开始、结束时间
	 */
	private String endDate;

	private String startDate;

	private String province;

	private String orderNo;

	/**
	 * 承办方
	 */
	private String sponsor;

	private String process;

	private String orderSerialNumber;

	/**
	 * 导出类型 0 订单 1 许可 2 备案
	 */
	private String exportType;

	/**
	 * 下单日期起始
	 */
	private String orderDateStart;

	/**
	 * 下单日期结束
	 */
	private String orderDateEnd;


	/**
	 * 活动结束时间起始
	 */
	private String endDate1;

	/**
	 * 活动结束时间结束
	 */
	private String endDate2;

	/**
	 * 活动创建时间开始
	 */
	private String createDateStart;

	/**
	 * 活动创建时间结束
	 */
	private String createDateEnd;


	/**
	 * 活动类型
	 */
	private String activityType;


	/**
	 * 关键词
	 */
	private String keyWord;

	/**
	 * 省份Id
	 */
	private String provinceId;

	/**
	 * 城市ID
	 */
	private String cityId;

	/**
	 * 区县ID
	 */
	private String areaId;


	/**
	 * 审批状态
	 */
	private String sbApprovalStatus;

	/**
	 * 排序规则
	 */
	private String sortValue;

	/**
	 * 是否需要风评
	 */
	private String isAssessment;


	/**
	 * 支付方式：线上、线下
	 */
	private String payMethod;
	/**
	 * 支付开始、结束时间
	 */
	private String payBeginDate;
	private String payEndDate;

	/**
	 * 活动开始时间范围
	 */
	private String activityStartDateFrom;
	private String activityStartDateTo;

	/**
	 * 活动结束时间范围
	 */
	private String activityEndDateFrom;
	private String activityEndDateTo;

	/**
	 * 创建时间范围
	 */
	private String createDateFrom;

	private String createDateTo;


	/**
	 * 活动城市
	 */
	private String activityCity;

	/**
	 * 审批状态
	 */
	private String approvalStatus;

	/**
	 * 排序
	 */
	private String order;

	/**
	 * 支付方式
	 */
	private String paymentMode;

	/**
	 * 支付金额
	 */
	private String amount;

	private String approvalUnit;

	/**
	 * 是否申报活动
	 */
	private String isShenBao;

}
	
