package com.bcxin.risk.order;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.policy.domain.InsurancePolicy;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 交易
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Transaction")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Transaction extends BaseBean {

	private static final long serialVersionUID = 1L;
	
	private String transactionObject; //交易对象 (字典)

	private String orderNo;//订单号（此值与产品订单号匹配）

	private String paymentMode;//支付方式（线下、线上）(字典)

	@Temporal(TemporalType.TIMESTAMP)
	private Date startTime;//交易开始时间

	@Temporal(TemporalType.TIMESTAMP)
	private Date endTime;//交易结束时间

	private BigDecimal amount;//交易金额

	private String payStatus;//支付状态（已支付，未支付）(字典)

	private String paymentType;//支付类型（支付宝、银联、微信等）(字典)

	@ManyToOne(targetEntity = OrderForm.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "orderForm_id")
	private OrderForm orderForm;//订单

	@ManyToOne(targetEntity = InsurancePolicy.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "insurancePolicy_id")
	private InsurancePolicy insurancePolicy;//保单

}
