package com.bcxin.risk.order;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.user.domain.User;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.math.BigDecimal;

/**
 *
 */
@Entity
@Table(name = "RISK_OrderForm")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class OrderForm extends BaseBean {

	private static final long serialVersionUID = 1L;
	
	private String orderNo;
	
	private BigDecimal reportAmount = BigDecimal.ZERO; //报告费用
	
	private BigDecimal contractAmount = BigDecimal.ZERO; //合同认证费用
	
	private BigDecimal monitorAmount = BigDecimal.ZERO; //视频监控费用
	
	private BigDecimal supplyAmount = BigDecimal.ZERO; //补充费用

	private BigDecimal refundAmount = BigDecimal.ZERO; // 退款金额

	private BigDecimal sourceAmount = BigDecimal.ZERO; // 原始金额

	private BigDecimal sourceReportAmount = BigDecimal.ZERO; // 原始金额

	private BigDecimal amount = BigDecimal.ZERO; //总费用

	private BigDecimal discountAmount = BigDecimal.ZERO; //报告折扣费用

	private String orderStatus ;//订单状态（字典）

	@ManyToOne(targetEntity = User.class, fetch = FetchType.EAGER, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "user_id")
	private User user;

	/**
	 * 活动信息
	 */
	@OneToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;

	private String needSyncOrder;//是否需要同步订单，0代表不需要，1代表需要

	private String syncOrder;//是否已同步订单，0代表未同步，1代表已同步

	public BigDecimal getOriginalAmount() {
		return this.amount.subtract(this.discountAmount).add(this.reportAmount);
	}

	private String isSync ; // 业务支撑同步标志 0:未同步，1:同步

	private String ywzcId ; // 业务支撑ID

	/**
	 * 延后支付凭证
	 */
	private String delayPhoto;
}
