package com.bcxin.risk.news.dto;

import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.news.domain.News;
import lombok.Data;
import org.hibernate.annotations.Type;

import java.util.Map;

/**
 * @param oid
 * @return
 * @auther Administrator
 * @date 2017/05/08 0008
 * @注意事项 </b>
 */
@Data
public class NewsDto {

    private String oid;
    private String updateOn;
    private String createOn;
    private String title;
    private String othercategorynews;
    private String release_time;
    /**
     * 内容
     */

    private String content;

    /**
     * 新闻来源
     */
    private String category; //字典

    /**
     * 类别
     */
    private String newsType; //字典

    //优先级
    private String priority; //2:重要； 1：最新； 0：普通(字典)

    //是否已经创建静态文件
    private boolean createStatic;

    //附件

    private String attachment; // 多个地址用#隔开（www.pss360.cn/a.doc#www.pss360.cn/b.doc）

    private String imgAddress;
    private Page page;
    public NewsDto(Map<String,Object> map){
        this.oid = safeTransfor(map.get("oid"));
        this.othercategorynews = safeTransfor(map.get("othercategorynews"));

        this.release_time = safeTransfor(map.get("release_time"));
        this.createOn = safeTransfor(map.get("createOn"));
        this.updateOn = safeTransfor(map.get("updateOn"));
        this.title = safeTransfor(map.get("title"));
        this.content = safeTransfor(map.get("content"));
        this.category = safeTransfor(map.get("category"));

        this.newsType = safeTransfor(map.get("newsType"));
        this.priority = safeTransfor(map.get("priority"));
        this.attachment = safeTransfor(map.get("attachment"));
        this.imgAddress = safeTransfor(map.get("imgAddress"));
    }


    /**
     *
     * <b>Function 将Object安全转换为String</b>
     *
     * @param obj
     * @return
     * @author WangChenYi
     * @date 2017年05月08日 下午2:19:22
     * @注意事项 </b>
     * <b>
     */
    private static String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }

}
