package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.enums.PushMethodEnum;
import com.bcxin.risk.enums.PushTypeEnum;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import java.text.SimpleDateFormat;
import java.util.Date;

@Entity
@Table(name = "RISK_PUSH_LOG")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class PushLog extends BaseBean {

    private String batchNo;

    private Date startTime;

    private Date endTime;

    private Long speedTime;

    private int success;

    private int fail;

    private int total;

    /**
     * 全部成功，部分成功，全部失败
     */
    private String flag;

    private String msg;

    /**
     * 活动信息
     */
    private String pushType;
    private String pushTypeName;

    /**
     * 推送方式
     * PSS_TO_SB,SB_TO_PSS
     */
    private String pushMethod;

    private String paramData;

    public PushLog(){

    }

    public PushLog(PushTypeEnum pushType, PushMethodEnum pushMethod, int total, int fail, int success, String msg, Date start){
        SimpleDateFormat df=new SimpleDateFormat("yyyyMMddHHmmss");
        Date end=new Date();
        this.setBatchNo("BATCH"+df.format(new Date()));
        this.setCreateOn(new Date());
        this.setFail(fail);
        this.setSuccess(success);
        this.setTotal(total);
        this.setPushType(pushType.getKey());
        this.setPushTypeName(pushType.getAlias());
        this.setStartTime(start);
        this.setEndTime(end);
        this.setSpeedTime(end.getTime()-start.getTime());
        this.setMsg(msg);
        this.setPushMethod(pushMethod.getKey());
       if(success==total){
           this.setFlag("SUCCESS");
       }else if(fail>0 && success>0){
           this.setFlag("PART SUCCESS");
       }else{
           this.setFlag("FAIL");
       }
    }

}
