package com.bcxin.risk.enums;

/**
 * 推送类型
 */
public enum PushTypeEnum {

    ACTIVITY_CHUSHEN_INFO("ACTIVITY_CHUSHEN_INFO","活动初审信息提交"),
    ACTIVITY_MATERIAL_BP("ACTIVITY_MATERIAL_BP","活动报批材料"),
    ACTIVITY_APPROVE_LOG("ACTIVITY_APPROVE_LOG","活动审批日志"),
    ACTIVITY_CHUSHEN_PASS("ACTIVITY_CHUSHEN_PASS","活动初审通过"),
    ACTIVITY_APPROVE_PASS("ACTIVITY_APPROVE_PASS","活动审批通过"),
    ACTIVITY_APPROVE_INFO("ACTIVITY_APPROVE_INFO","活动审批信息提交"),

    ACTIVITY_BASIC_CHANGE_LOG("ACTIVITY_BASIC_CHANGE_LOG","活动修改基础信息提交"),
    ACTIVITY_MATERIAL_CHANGE_LOG("ACTIVITY_MATERIAL_CHANGE_LOG","活动修改材料信息提交"),

    ACTIVITY_INFO_GOV("ACTIVITY_INFO_GOV","政府类活动信息提交"),
    ACTIVITY_SEND_MESSAGE("ACTIVITY_SEND_MESSAGE","发送活动通知消息"),


    LOG_SP_UPGRADE_TIPS("LOG_SP_UPGRADE_TIPS","内网升级日志推送");

    private String key;
    private String alias;

    PushTypeEnum(String key, String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(PushTypeEnum e : PushTypeEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
