package com.bcxin.risk.dynamic.dto;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.survey.domain.Task;
import com.bcxin.risk.user.domain.User;
import lombok.Data;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.io.Serializable;

/**
 * @author hzp
 * 踏勘动态看板数据结构
 * 数据结构属性与对应的模板key相对应
 */
@Data
public class DynamicSurveyPanel implements Serializable {

    private String taskId;
    /**
     * 操作人
     */
    private String operateId;
    private String operateName;
    private String userName;

    /**
     * 承办方
     */
    private String contractId;
    private String contractName;

    /**
     * 活动
     */
    private String activityId;
    private String activityName;

    /**
     * 踏勘人员
     */
    private String tkUserId;
    private String tkUserName;

    /**
     * 踏勘专家
     */
    private String tkzjUserList;

    /**
     * 踏勘场馆
     */
    private String tkVenue;

    /**
     * 踏勘时间
     */
    private String tkTime;

    /**
     * 踏勘阶段
     */
    private String step;

    /**
     * 踏勘报告
     */
    private String surveyReport;

    /**
     * 踏勘整改意见
     */
    private JSONArray reformList;


    /**
     * 踏勘整改回复
     */
    private JSONArray reformSuggest;


    public DynamicSurveyPanel(User operateUser,Activity activity,String suggest,String photos,String step){
        if(operateUser!=null){
            this.operateId=safeTransfer(operateUser.getOid());
            this.userName=operateUser.getUserName();
            if(StringUtil.isEmpty(this.operateName)){
                this.operateName=safeTransfer(operateUser.getUserName());
            }
        }
        if(activity!=null){
            this.activityId=safeTransfer(activity.getOid());
            this.activityName=safeTransfer(activity.getName());
            this.contractId=safeTransfer(activity.getOrg().getOid());
            this.contractName=safeTransfer(activity.getOrg().getName());
        }
        this.step=step;

        JSONArray array=new JSONArray();
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("zgSuggest",suggest);
        jsonObject.put("zgPhoto",photos);
        array.add(jsonObject);
        this.reformSuggest=array;
    }

    public DynamicSurveyPanel(User operateUser, Task task,User tkUser,String tkzjUserList){
        Activity activity=task.getActivity();

        if(tkUser!=null){
            this.tkUserName=safeTransfer(tkUser.getRealName());
            if(StringUtil.isEmpty(this.tkUserName)){
                this.tkUserName= tkUser.getUserName();
            }
        }
        if(operateUser!=null){
            this.operateId=safeTransfer(operateUser.getOid());
            this.userName=operateUser.getUserName();
            if(StringUtil.isEmpty(this.operateName)){
                this.operateName=safeTransfer(operateUser.getUserName());
            }
        }

        if(activity!=null){
            this.activityId=safeTransfer(activity.getOid());
            this.activityName=safeTransfer(activity.getName());
        }
        this.tkzjUserList=tkzjUserList;
    }

    private static String safeTransfer(Object obj){
        if(obj!=null){
            return obj.toString();
        }
        return "";
    }

}
