package com.bcxin.risk.dynamic.dto;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.enums.DynamicTypeEnum;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;
import net.sf.json.JSONObject;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.*;

/**
 * @author hzp
 * 动态看板列表数据dto
 */
@Data
public class DynamicPanelDto implements Serializable {

    private String template;

    private String templateId;

    private JSONObject templateData;

    private String dynamicType;

    private String dynamicTypeName;

    private String createOn;

    private String title;

    private Page page;

    public DynamicPanelDto(Map<String,Object> map){
        this.template=safeTransfer(map.get("template"));
        this.templateId=safeTransfer(map.get("templateId"));
        this.dynamicType=safeTransfer(map.get("dynamicType"));
        if(StringUtil.isNotEmpty(dynamicType)){
            this.dynamicTypeName=DynamicTypeEnum.getAlias(dynamicType);
        }
        this.templateData=JSONObject.fromObject(safeTransfer(map.get("templateData")));
        this.createOn=safeTransfer(map.get("createOn"));
        this.title=createTitle(template,templateData);
    }

    private static String safeTransfer(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }

    private static String createTitle(String template,JSONObject templateData){
        if(listPro.isEmpty()){
            listPro=getAllProperty();
        }
        for(String key : listPro){
            // 获得key
            Object obj = templateData.get(key);
            String value="";
            if(obj!=null){
                value=obj.toString();
            }
            template=template.replace("@"+key+"@",value);
        }
        return template;

//        Iterator<String> it = templateData.keys();
//        while(it.hasNext()){
//            // 获得key
//            String key = it.next();
//            String value = templateData.getString(key);
//            template=template.replace("@"+key+"@",value);
//        }
//        return template;
    }

    private static List<String> listPro=new ArrayList<>();
    static {
        if(listPro.isEmpty()){
            listPro=getAllProperty();
        }
    }

    /**
     * 获取动态看板所有属性
     * @return
     */
    private static List<String> getAllProperty(){
        List<String> list=new ArrayList<>();
        Field [] fieldsFP=DynamicFengPingPanel.class.getDeclaredFields();
        Field [] fieldsOrder=DynamicOrderPanel.class.getDeclaredFields();
        Field [] fieldsSurvey=DynamicSurveyPanel.class.getDeclaredFields();
        Field [] fieldsZX=DynamicZhuanXiePanel.class.getDeclaredFields();
        Field [] fieldsAct=DynamicActPanel.class.getDeclaredFields();
        Field [] fieldsApprove=DynamicApprovePanel.class.getDeclaredFields();
        List<Field> listField=new ArrayList<>();
        listField.addAll(Arrays.asList(fieldsFP));
        listField.addAll(Arrays.asList(fieldsOrder));
        listField.addAll(Arrays.asList(fieldsSurvey));
        listField.addAll(Arrays.asList(fieldsZX));
        listField.addAll(Arrays.asList(fieldsAct));
        listField.addAll(Arrays.asList(fieldsApprove));
        for(Field f:listField){
            String name=f.getName();
            if(!list.contains(name)){
                list.add(name);
            }
        }
        return list;
    }
}
